/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union cl_device_topology_amd")
public class CLDeviceTopologyAMD
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RAW;
    public static final int RAW_TYPE;
    public static final int RAW_DATA;
    public static final int PCIE;
    public static final int PCIE_TYPE;
    public static final int PCIE_BUS;
    public static final int PCIE_DEVICE;
    public static final int PCIE_FUNCTION;

    CLDeviceTopologyAMD(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public CLDeviceTopologyAMD(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CLDeviceTopologyAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_uint")
    public int raw_type() {
        return CLDeviceTopologyAMD.nraw_type(this.address());
    }

    @NativeType(value="cl_uint[5]")
    public IntBuffer raw_data() {
        return CLDeviceTopologyAMD.nraw_data(this.address());
    }

    @NativeType(value="cl_uint")
    public int raw_data(int index) {
        return CLDeviceTopologyAMD.nraw_data(this.address(), index);
    }

    @NativeType(value="cl_uint")
    public int pcie_type() {
        return CLDeviceTopologyAMD.npcie_type(this.address());
    }

    @NativeType(value="cl_char")
    public byte pcie_bus() {
        return CLDeviceTopologyAMD.npcie_bus(this.address());
    }

    @NativeType(value="cl_char")
    public byte pcie_device() {
        return CLDeviceTopologyAMD.npcie_device(this.address());
    }

    @NativeType(value="cl_char")
    public byte pcie_function() {
        return CLDeviceTopologyAMD.npcie_function(this.address());
    }

    public static CLDeviceTopologyAMD malloc() {
        return CLDeviceTopologyAMD.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLDeviceTopologyAMD calloc() {
        return CLDeviceTopologyAMD.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLDeviceTopologyAMD create() {
        return new CLDeviceTopologyAMD(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CLDeviceTopologyAMD create(long address) {
        return new CLDeviceTopologyAMD(address, null);
    }

    @Nullable
    public static CLDeviceTopologyAMD createSafe(long address) {
        return address == 0L ? null : CLDeviceTopologyAMD.create(address);
    }

    public static Buffer malloc(int capacity) {
        return CLDeviceTopologyAMD.create(CLDeviceTopologyAMD.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLDeviceTopologyAMD.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(CLDeviceTopologyAMD.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLDeviceTopologyAMD.create(address, capacity);
    }

    public static CLDeviceTopologyAMD mallocStack() {
        return CLDeviceTopologyAMD.mallocStack(MemoryStack.stackGet());
    }

    public static CLDeviceTopologyAMD callocStack() {
        return CLDeviceTopologyAMD.callocStack(MemoryStack.stackGet());
    }

    public static CLDeviceTopologyAMD mallocStack(MemoryStack stack) {
        return CLDeviceTopologyAMD.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLDeviceTopologyAMD callocStack(MemoryStack stack) {
        return CLDeviceTopologyAMD.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLDeviceTopologyAMD.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLDeviceTopologyAMD.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLDeviceTopologyAMD.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLDeviceTopologyAMD.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nraw_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RAW_TYPE);
    }

    public static IntBuffer nraw_data(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RAW_DATA, 5);
    }

    public static int nraw_data(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)RAW_DATA + Checks.check(index, 5) * 4L);
    }

    public static int npcie_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PCIE_TYPE);
    }

    public static byte npcie_bus(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PCIE_BUS);
    }

    public static byte npcie_device(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PCIE_DEVICE);
    }

    public static byte npcie_function(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PCIE_FUNCTION);
    }

    static {
        Struct.Layout layout = CLDeviceTopologyAMD.__union(CLDeviceTopologyAMD.__struct(CLDeviceTopologyAMD.__member(4), CLDeviceTopologyAMD.__array(4, 5)), CLDeviceTopologyAMD.__struct(CLDeviceTopologyAMD.__member(4), CLDeviceTopologyAMD.__padding(17, true), CLDeviceTopologyAMD.__member(1), CLDeviceTopologyAMD.__member(1), CLDeviceTopologyAMD.__member(1)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RAW = layout.offsetof(0);
        RAW_TYPE = layout.offsetof(1);
        RAW_DATA = layout.offsetof(2);
        PCIE = layout.offsetof(3);
        PCIE_TYPE = layout.offsetof(4);
        PCIE_BUS = layout.offsetof(6);
        PCIE_DEVICE = layout.offsetof(7);
        PCIE_FUNCTION = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<CLDeviceTopologyAMD, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CLDeviceTopologyAMD newInstance(long address) {
            return new CLDeviceTopologyAMD(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="cl_uint")
        public int raw_type() {
            return CLDeviceTopologyAMD.nraw_type(this.address());
        }

        @NativeType(value="cl_uint[5]")
        public IntBuffer raw_data() {
            return CLDeviceTopologyAMD.nraw_data(this.address());
        }

        @NativeType(value="cl_uint")
        public int raw_data(int index) {
            return CLDeviceTopologyAMD.nraw_data(this.address(), index);
        }

        @NativeType(value="cl_uint")
        public int pcie_type() {
            return CLDeviceTopologyAMD.npcie_type(this.address());
        }

        @NativeType(value="cl_char")
        public byte pcie_bus() {
            return CLDeviceTopologyAMD.npcie_bus(this.address());
        }

        @NativeType(value="cl_char")
        public byte pcie_device() {
            return CLDeviceTopologyAMD.npcie_device(this.address());
        }

        @NativeType(value="cl_char")
        public byte pcie_function() {
            return CLDeviceTopologyAMD.npcie_function(this.address());
        }
    }
}

