/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SQL_DAY_SECOND_STRUCT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DAY;
    public static final int HOUR;
    public static final int MINUTE;
    public static final int SECOND;
    public static final int FRACTION;

    SQL_DAY_SECOND_STRUCT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public SQL_DAY_SECOND_STRUCT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), SQL_DAY_SECOND_STRUCT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SQLUINTEGER")
    public int day() {
        return SQL_DAY_SECOND_STRUCT.nday(this.address());
    }

    @NativeType(value="SQLUINTEGER")
    public int hour() {
        return SQL_DAY_SECOND_STRUCT.nhour(this.address());
    }

    @NativeType(value="SQLUINTEGER")
    public int minute() {
        return SQL_DAY_SECOND_STRUCT.nminute(this.address());
    }

    @NativeType(value="SQLUINTEGER")
    public int second() {
        return SQL_DAY_SECOND_STRUCT.nsecond(this.address());
    }

    @NativeType(value="SQLUINTEGER")
    public int fraction() {
        return SQL_DAY_SECOND_STRUCT.nfraction(this.address());
    }

    public SQL_DAY_SECOND_STRUCT day(@NativeType(value="SQLUINTEGER") int value) {
        SQL_DAY_SECOND_STRUCT.nday(this.address(), value);
        return this;
    }

    public SQL_DAY_SECOND_STRUCT hour(@NativeType(value="SQLUINTEGER") int value) {
        SQL_DAY_SECOND_STRUCT.nhour(this.address(), value);
        return this;
    }

    public SQL_DAY_SECOND_STRUCT minute(@NativeType(value="SQLUINTEGER") int value) {
        SQL_DAY_SECOND_STRUCT.nminute(this.address(), value);
        return this;
    }

    public SQL_DAY_SECOND_STRUCT second(@NativeType(value="SQLUINTEGER") int value) {
        SQL_DAY_SECOND_STRUCT.nsecond(this.address(), value);
        return this;
    }

    public SQL_DAY_SECOND_STRUCT fraction(@NativeType(value="SQLUINTEGER") int value) {
        SQL_DAY_SECOND_STRUCT.nfraction(this.address(), value);
        return this;
    }

    public SQL_DAY_SECOND_STRUCT set(int day, int hour, int minute, int second, int fraction) {
        this.day(day);
        this.hour(hour);
        this.minute(minute);
        this.second(second);
        this.fraction(fraction);
        return this;
    }

    public SQL_DAY_SECOND_STRUCT set(SQL_DAY_SECOND_STRUCT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SQL_DAY_SECOND_STRUCT malloc() {
        return SQL_DAY_SECOND_STRUCT.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SQL_DAY_SECOND_STRUCT calloc() {
        return SQL_DAY_SECOND_STRUCT.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SQL_DAY_SECOND_STRUCT create() {
        return new SQL_DAY_SECOND_STRUCT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static SQL_DAY_SECOND_STRUCT create(long address) {
        return new SQL_DAY_SECOND_STRUCT(address, null);
    }

    @Nullable
    public static SQL_DAY_SECOND_STRUCT createSafe(long address) {
        return address == 0L ? null : SQL_DAY_SECOND_STRUCT.create(address);
    }

    public static Buffer malloc(int capacity) {
        return SQL_DAY_SECOND_STRUCT.create(SQL_DAY_SECOND_STRUCT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SQL_DAY_SECOND_STRUCT.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(SQL_DAY_SECOND_STRUCT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SQL_DAY_SECOND_STRUCT.create(address, capacity);
    }

    public static SQL_DAY_SECOND_STRUCT mallocStack() {
        return SQL_DAY_SECOND_STRUCT.mallocStack(MemoryStack.stackGet());
    }

    public static SQL_DAY_SECOND_STRUCT callocStack() {
        return SQL_DAY_SECOND_STRUCT.callocStack(MemoryStack.stackGet());
    }

    public static SQL_DAY_SECOND_STRUCT mallocStack(MemoryStack stack) {
        return SQL_DAY_SECOND_STRUCT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SQL_DAY_SECOND_STRUCT callocStack(MemoryStack stack) {
        return SQL_DAY_SECOND_STRUCT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return SQL_DAY_SECOND_STRUCT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return SQL_DAY_SECOND_STRUCT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return SQL_DAY_SECOND_STRUCT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return SQL_DAY_SECOND_STRUCT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nday(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DAY);
    }

    public static int nhour(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HOUR);
    }

    public static int nminute(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINUTE);
    }

    public static int nsecond(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SECOND);
    }

    public static int nfraction(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRACTION);
    }

    public static void nday(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DAY, value);
    }

    public static void nhour(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HOUR, value);
    }

    public static void nminute(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MINUTE, value);
    }

    public static void nsecond(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SECOND, value);
    }

    public static void nfraction(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRACTION, value);
    }

    static {
        Struct.Layout layout = SQL_DAY_SECOND_STRUCT.__struct(SQL_DAY_SECOND_STRUCT.__member(4), SQL_DAY_SECOND_STRUCT.__member(4), SQL_DAY_SECOND_STRUCT.__member(4), SQL_DAY_SECOND_STRUCT.__member(4), SQL_DAY_SECOND_STRUCT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DAY = layout.offsetof(0);
        HOUR = layout.offsetof(1);
        MINUTE = layout.offsetof(2);
        SECOND = layout.offsetof(3);
        FRACTION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<SQL_DAY_SECOND_STRUCT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected SQL_DAY_SECOND_STRUCT newInstance(long address) {
            return new SQL_DAY_SECOND_STRUCT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="SQLUINTEGER")
        public int day() {
            return SQL_DAY_SECOND_STRUCT.nday(this.address());
        }

        @NativeType(value="SQLUINTEGER")
        public int hour() {
            return SQL_DAY_SECOND_STRUCT.nhour(this.address());
        }

        @NativeType(value="SQLUINTEGER")
        public int minute() {
            return SQL_DAY_SECOND_STRUCT.nminute(this.address());
        }

        @NativeType(value="SQLUINTEGER")
        public int second() {
            return SQL_DAY_SECOND_STRUCT.nsecond(this.address());
        }

        @NativeType(value="SQLUINTEGER")
        public int fraction() {
            return SQL_DAY_SECOND_STRUCT.nfraction(this.address());
        }

        public Buffer day(@NativeType(value="SQLUINTEGER") int value) {
            SQL_DAY_SECOND_STRUCT.nday(this.address(), value);
            return this;
        }

        public Buffer hour(@NativeType(value="SQLUINTEGER") int value) {
            SQL_DAY_SECOND_STRUCT.nhour(this.address(), value);
            return this;
        }

        public Buffer minute(@NativeType(value="SQLUINTEGER") int value) {
            SQL_DAY_SECOND_STRUCT.nminute(this.address(), value);
            return this;
        }

        public Buffer second(@NativeType(value="SQLUINTEGER") int value) {
            SQL_DAY_SECOND_STRUCT.nsecond(this.address(), value);
            return this;
        }

        public Buffer fraction(@NativeType(value="SQLUINTEGER") int value) {
            SQL_DAY_SECOND_STRUCT.nfraction(this.address(), value);
            return this;
        }
    }
}

