/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkClipboard;
import org.lwjgl.nuklear.NkPluginFilter;
import org.lwjgl.nuklear.NkStr;
import org.lwjgl.nuklear.NkTextUndoState;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_text_edit")
class NkTextEdit
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CLIP;
    public static final int STRING;
    public static final int FILTER;
    public static final int SCROLLBAR;
    public static final int CURSOR;
    public static final int SELECT_START;
    public static final int SELECT_END;
    public static final int MODE;
    public static final int CURSOR_AT_END_OF_LINE;
    public static final int INITIALIZED;
    public static final int HAS_PREFERRED_X;
    public static final int SINGLE_LINE;
    public static final int ACTIVE;
    public static final int PREFERRED_X;
    public static final int UNDO;

    NkTextEdit(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    NkTextEdit(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkTextEdit.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_clipboard")
    public NkClipboard clip() {
        return NkTextEdit.nclip(this.address());
    }

    public NkTextEdit clip(Consumer<NkClipboard> consumer) {
        consumer.accept(this.clip());
        return this;
    }

    @NativeType(value="struct nk_str")
    public NkStr string() {
        return NkTextEdit.nstring(this.address());
    }

    @Nullable
    @NativeType(value="nk_plugin_filter")
    public NkPluginFilter filter() {
        return NkTextEdit.nfilter(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 scrollbar() {
        return NkTextEdit.nscrollbar(this.address());
    }

    public NkTextEdit scrollbar(Consumer<NkVec2> consumer) {
        consumer.accept(this.scrollbar());
        return this;
    }

    public int cursor() {
        return NkTextEdit.ncursor(this.address());
    }

    public int select_start() {
        return NkTextEdit.nselect_start(this.address());
    }

    public int select_end() {
        return NkTextEdit.nselect_end(this.address());
    }

    @NativeType(value="unsigned char")
    public byte mode() {
        return NkTextEdit.nmode(this.address());
    }

    @NativeType(value="bool")
    public boolean cursor_at_end_of_line() {
        return NkTextEdit.ncursor_at_end_of_line(this.address());
    }

    @NativeType(value="bool")
    public boolean initialized() {
        return NkTextEdit.ninitialized(this.address());
    }

    @NativeType(value="bool")
    public boolean has_preferred_x() {
        return NkTextEdit.nhas_preferred_x(this.address());
    }

    @NativeType(value="bool")
    public boolean single_line() {
        return NkTextEdit.nsingle_line(this.address());
    }

    @NativeType(value="bool")
    public boolean active() {
        return NkTextEdit.nactive(this.address());
    }

    public float preferred_x() {
        return NkTextEdit.npreferred_x(this.address());
    }

    @NativeType(value="struct nk_text_undo_state")
    public NkTextUndoState undo() {
        return NkTextEdit.nundo(this.address());
    }

    public static NkTextEdit malloc() {
        return NkTextEdit.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkTextEdit calloc() {
        return NkTextEdit.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkTextEdit create() {
        return new NkTextEdit(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkTextEdit create(long address) {
        return new NkTextEdit(address, null);
    }

    @Nullable
    public static NkTextEdit createSafe(long address) {
        return address == 0L ? null : NkTextEdit.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkTextEdit.create(NkTextEdit.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkTextEdit.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkTextEdit.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkTextEdit.create(address, capacity);
    }

    public static NkTextEdit mallocStack() {
        return NkTextEdit.mallocStack(MemoryStack.stackGet());
    }

    public static NkTextEdit callocStack() {
        return NkTextEdit.callocStack(MemoryStack.stackGet());
    }

    public static NkTextEdit mallocStack(MemoryStack stack) {
        return NkTextEdit.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkTextEdit callocStack(MemoryStack stack) {
        return NkTextEdit.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkTextEdit.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkTextEdit.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkTextEdit.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkTextEdit.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkClipboard nclip(long struct) {
        return NkClipboard.create(struct + (long)CLIP);
    }

    public static NkStr nstring(long struct) {
        return NkStr.create(struct + (long)STRING);
    }

    @Nullable
    public static NkPluginFilter nfilter(long struct) {
        return NkPluginFilter.createSafe(MemoryUtil.memGetAddress(struct + (long)FILTER));
    }

    public static NkVec2 nscrollbar(long struct) {
        return NkVec2.create(struct + (long)SCROLLBAR);
    }

    public static int ncursor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURSOR);
    }

    public static int nselect_start(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SELECT_START);
    }

    public static int nselect_end(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SELECT_END);
    }

    public static byte nmode(long struct) {
        return MemoryUtil.memGetByte(struct + (long)MODE);
    }

    public static boolean ncursor_at_end_of_line(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CURSOR_AT_END_OF_LINE) != 0;
    }

    public static boolean ninitialized(long struct) {
        return MemoryUtil.memGetByte(struct + (long)INITIALIZED) != 0;
    }

    public static boolean nhas_preferred_x(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HAS_PREFERRED_X) != 0;
    }

    public static boolean nsingle_line(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SINGLE_LINE) != 0;
    }

    public static boolean nactive(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ACTIVE) != 0;
    }

    public static float npreferred_x(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PREFERRED_X);
    }

    public static NkTextUndoState nundo(long struct) {
        return NkTextUndoState.create(struct + (long)UNDO);
    }

    static {
        Struct.Layout layout = NkTextEdit.__struct(NkTextEdit.__member(NkClipboard.SIZEOF, NkClipboard.ALIGNOF), NkTextEdit.__member(NkStr.SIZEOF, NkStr.ALIGNOF), NkTextEdit.__member(POINTER_SIZE), NkTextEdit.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkTextEdit.__member(4), NkTextEdit.__member(4), NkTextEdit.__member(4), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__padding(1, true), NkTextEdit.__member(4), NkTextEdit.__member(NkTextUndoState.SIZEOF, NkTextUndoState.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CLIP = layout.offsetof(0);
        STRING = layout.offsetof(1);
        FILTER = layout.offsetof(2);
        SCROLLBAR = layout.offsetof(3);
        CURSOR = layout.offsetof(4);
        SELECT_START = layout.offsetof(5);
        SELECT_END = layout.offsetof(6);
        MODE = layout.offsetof(7);
        CURSOR_AT_END_OF_LINE = layout.offsetof(8);
        INITIALIZED = layout.offsetof(9);
        HAS_PREFERRED_X = layout.offsetof(10);
        SINGLE_LINE = layout.offsetof(11);
        ACTIVE = layout.offsetof(12);
        PREFERRED_X = layout.offsetof(14);
        UNDO = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<NkTextEdit, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkTextEdit newInstance(long address) {
            return new NkTextEdit(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct nk_clipboard")
        public NkClipboard clip() {
            return NkTextEdit.nclip(this.address());
        }

        public Buffer clip(Consumer<NkClipboard> consumer) {
            consumer.accept(this.clip());
            return this;
        }

        @NativeType(value="struct nk_str")
        public NkStr string() {
            return NkTextEdit.nstring(this.address());
        }

        @Nullable
        @NativeType(value="nk_plugin_filter")
        public NkPluginFilter filter() {
            return NkTextEdit.nfilter(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 scrollbar() {
            return NkTextEdit.nscrollbar(this.address());
        }

        public Buffer scrollbar(Consumer<NkVec2> consumer) {
            consumer.accept(this.scrollbar());
            return this;
        }

        public int cursor() {
            return NkTextEdit.ncursor(this.address());
        }

        public int select_start() {
            return NkTextEdit.nselect_start(this.address());
        }

        public int select_end() {
            return NkTextEdit.nselect_end(this.address());
        }

        @NativeType(value="unsigned char")
        public byte mode() {
            return NkTextEdit.nmode(this.address());
        }

        @NativeType(value="bool")
        public boolean cursor_at_end_of_line() {
            return NkTextEdit.ncursor_at_end_of_line(this.address());
        }

        @NativeType(value="bool")
        public boolean initialized() {
            return NkTextEdit.ninitialized(this.address());
        }

        @NativeType(value="bool")
        public boolean has_preferred_x() {
            return NkTextEdit.nhas_preferred_x(this.address());
        }

        @NativeType(value="bool")
        public boolean single_line() {
            return NkTextEdit.nsingle_line(this.address());
        }

        @NativeType(value="bool")
        public boolean active() {
            return NkTextEdit.nactive(this.address());
        }

        public float preferred_x() {
            return NkTextEdit.npreferred_x(this.address());
        }

        @NativeType(value="struct nk_text_undo_state")
        public NkTextUndoState undo() {
            return NkTextEdit.nundo(this.address());
        }
    }
}

