/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_text")
public class NkStyleText
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int PADDING;

    NkStyleText(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkStyleText(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkStyleText.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleText.ncolor(this.address());
    }

    public NkStyleText color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleText.npadding(this.address());
    }

    public NkStyleText padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleText color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleText.ncolor(this.address(), value);
        return this;
    }

    public NkStyleText padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleText.npadding(this.address(), value);
        return this;
    }

    public NkStyleText set(NkColor color, NkVec2 padding) {
        this.color(color);
        this.padding(padding);
        return this;
    }

    public NkStyleText set(NkStyleText src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleText malloc() {
        return NkStyleText.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkStyleText calloc() {
        return NkStyleText.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkStyleText create() {
        return new NkStyleText(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkStyleText create(long address) {
        return new NkStyleText(address, null);
    }

    @Nullable
    public static NkStyleText createSafe(long address) {
        return address == 0L ? null : NkStyleText.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkStyleText.create(NkStyleText.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkStyleText.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkStyleText.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkStyleText.create(address, capacity);
    }

    public static NkStyleText mallocStack() {
        return NkStyleText.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleText callocStack() {
        return NkStyleText.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleText mallocStack(MemoryStack stack) {
        return NkStyleText.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleText callocStack(MemoryStack stack) {
        return NkStyleText.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleText.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleText.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleText.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleText.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, NkColor.SIZEOF);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleText.__struct(NkStyleText.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleText.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        PADDING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStyleText, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkStyleText newInstance(long address) {
            return new NkStyleText(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleText.ncolor(this.address());
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleText.npadding(this.address());
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleText.ncolor(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleText.npadding(this.address(), value);
            return this;
        }
    }
}

