/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_rect")
public class NkRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    NkRect(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkRect(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkRect.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return NkRect.nx(this.address());
    }

    public float y() {
        return NkRect.ny(this.address());
    }

    public float w() {
        return NkRect.nw(this.address());
    }

    public float h() {
        return NkRect.nh(this.address());
    }

    public NkRect x(float value) {
        NkRect.nx(this.address(), value);
        return this;
    }

    public NkRect y(float value) {
        NkRect.ny(this.address(), value);
        return this;
    }

    public NkRect w(float value) {
        NkRect.nw(this.address(), value);
        return this;
    }

    public NkRect h(float value) {
        NkRect.nh(this.address(), value);
        return this;
    }

    public NkRect set(float x, float y, float w, float h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public NkRect set(NkRect src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkRect malloc() {
        return NkRect.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkRect calloc() {
        return NkRect.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkRect create() {
        return new NkRect(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkRect create(long address) {
        return new NkRect(address, null);
    }

    @Nullable
    public static NkRect createSafe(long address) {
        return address == 0L ? null : NkRect.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkRect.create(NkRect.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkRect.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkRect.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkRect.create(address, capacity);
    }

    public static NkRect mallocStack() {
        return NkRect.mallocStack(MemoryStack.stackGet());
    }

    public static NkRect callocStack() {
        return NkRect.callocStack(MemoryStack.stackGet());
    }

    public static NkRect mallocStack(MemoryStack stack) {
        return NkRect.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkRect callocStack(MemoryStack stack) {
        return NkRect.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkRect.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkRect.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkRect.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkRect.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static float nh(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)H);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    public static void nh(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)H, value);
    }

    static {
        Struct.Layout layout = NkRect.__struct(NkRect.__member(4), NkRect.__member(4), NkRect.__member(4), NkRect.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkRect, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkRect newInstance(long address) {
            return new NkRect(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return NkRect.nx(this.address());
        }

        public float y() {
            return NkRect.ny(this.address());
        }

        public float w() {
            return NkRect.nw(this.address());
        }

        public float h() {
            return NkRect.nh(this.address());
        }

        public Buffer x(float value) {
            NkRect.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            NkRect.ny(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            NkRect.nw(this.address(), value);
            return this;
        }

        public Buffer h(float value) {
            NkRect.nh(this.address(), value);
            return this;
        }
    }
}

