/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_popup_buffer")
public class NkPopupBuffer
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BEGIN;
    public static final int PARENT;
    public static final int LAST;
    public static final int END;
    public static final int ACTIVE;

    NkPopupBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkPopupBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkPopupBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_size")
    public long begin() {
        return NkPopupBuffer.nbegin(this.address());
    }

    @NativeType(value="nk_size")
    public long parent() {
        return NkPopupBuffer.nparent(this.address());
    }

    @NativeType(value="nk_size")
    public long last() {
        return NkPopupBuffer.nlast(this.address());
    }

    @NativeType(value="nk_size")
    public long end() {
        return NkPopupBuffer.nend(this.address());
    }

    public int active() {
        return NkPopupBuffer.nactive(this.address());
    }

    public static NkPopupBuffer create(long address) {
        return new NkPopupBuffer(address, null);
    }

    @Nullable
    public static NkPopupBuffer createSafe(long address) {
        return address == 0L ? null : NkPopupBuffer.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkPopupBuffer.create(address, capacity);
    }

    public static long nbegin(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BEGIN);
    }

    public static long nparent(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PARENT);
    }

    public static long nlast(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LAST);
    }

    public static long nend(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)END);
    }

    public static int nactive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIVE);
    }

    static {
        Struct.Layout layout = NkPopupBuffer.__struct(NkPopupBuffer.__member(POINTER_SIZE), NkPopupBuffer.__member(POINTER_SIZE), NkPopupBuffer.__member(POINTER_SIZE), NkPopupBuffer.__member(POINTER_SIZE), NkPopupBuffer.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BEGIN = layout.offsetof(0);
        PARENT = layout.offsetof(1);
        LAST = layout.offsetof(2);
        END = layout.offsetof(3);
        ACTIVE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkPopupBuffer, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkPopupBuffer newInstance(long address) {
            return new NkPopupBuffer(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="nk_size")
        public long begin() {
            return NkPopupBuffer.nbegin(this.address());
        }

        @NativeType(value="nk_size")
        public long parent() {
            return NkPopupBuffer.nparent(this.address());
        }

        @NativeType(value="nk_size")
        public long last() {
            return NkPopupBuffer.nlast(this.address());
        }

        @NativeType(value="nk_size")
        public long end() {
            return NkPopupBuffer.nend(this.address());
        }

        public int active() {
            return NkPopupBuffer.nactive(this.address());
        }
    }
}

