/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_draw_command")
public class NkDrawCommand
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ELEM_COUNT;
    public static final int CLIP_RECT;
    public static final int TEXTURE;
    public static final int USERDATA;

    NkDrawCommand(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkDrawCommand(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkDrawCommand.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int elem_count() {
        return NkDrawCommand.nelem_count(this.address());
    }

    @NativeType(value="struct nk_rect")
    public NkRect clip_rect() {
        return NkDrawCommand.nclip_rect(this.address());
    }

    public NkDrawCommand clip_rect(Consumer<NkRect> consumer) {
        consumer.accept(this.clip_rect());
        return this;
    }

    @NativeType(value="nk_handle")
    public NkHandle texture() {
        return NkDrawCommand.ntexture(this.address());
    }

    public NkDrawCommand texture(Consumer<NkHandle> consumer) {
        consumer.accept(this.texture());
        return this;
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkDrawCommand.nuserdata(this.address());
    }

    public NkDrawCommand userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public static NkDrawCommand create(long address) {
        return new NkDrawCommand(address, null);
    }

    @Nullable
    public static NkDrawCommand createSafe(long address) {
        return address == 0L ? null : NkDrawCommand.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkDrawCommand.create(address, capacity);
    }

    public static int nelem_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ELEM_COUNT);
    }

    public static NkRect nclip_rect(long struct) {
        return NkRect.create(struct + (long)CLIP_RECT);
    }

    public static NkHandle ntexture(long struct) {
        return NkHandle.create(struct + (long)TEXTURE);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    static {
        Struct.Layout layout = NkDrawCommand.__struct(NkDrawCommand.__member(4), NkDrawCommand.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkDrawCommand.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkDrawCommand.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ELEM_COUNT = layout.offsetof(0);
        CLIP_RECT = layout.offsetof(1);
        TEXTURE = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkDrawCommand, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkDrawCommand newInstance(long address) {
            return new NkDrawCommand(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned int")
        public int elem_count() {
            return NkDrawCommand.nelem_count(this.address());
        }

        @NativeType(value="struct nk_rect")
        public NkRect clip_rect() {
            return NkDrawCommand.nclip_rect(this.address());
        }

        public Buffer clip_rect(Consumer<NkRect> consumer) {
            consumer.accept(this.clip_rect());
            return this;
        }

        @NativeType(value="nk_handle")
        public NkHandle texture() {
            return NkDrawCommand.ntexture(this.address());
        }

        public Buffer texture(Consumer<NkHandle> consumer) {
            consumer.accept(this.texture());
            return this;
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkDrawCommand.nuserdata(this.address());
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }
    }
}

