/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_colorf")
public class NkColorf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    NkColorf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkColorf(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkColorf.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return NkColorf.nr(this.address());
    }

    public float g() {
        return NkColorf.ng(this.address());
    }

    public float b() {
        return NkColorf.nb(this.address());
    }

    public float a() {
        return NkColorf.na(this.address());
    }

    public NkColorf r(float value) {
        NkColorf.nr(this.address(), value);
        return this;
    }

    public NkColorf g(float value) {
        NkColorf.ng(this.address(), value);
        return this;
    }

    public NkColorf b(float value) {
        NkColorf.nb(this.address(), value);
        return this;
    }

    public NkColorf a(float value) {
        NkColorf.na(this.address(), value);
        return this;
    }

    public NkColorf set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public NkColorf set(NkColorf src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkColorf malloc() {
        return NkColorf.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkColorf calloc() {
        return NkColorf.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkColorf create() {
        return new NkColorf(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkColorf create(long address) {
        return new NkColorf(address, null);
    }

    @Nullable
    public static NkColorf createSafe(long address) {
        return address == 0L ? null : NkColorf.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkColorf.create(NkColorf.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkColorf.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkColorf.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkColorf.create(address, capacity);
    }

    public static NkColorf mallocStack() {
        return NkColorf.mallocStack(MemoryStack.stackGet());
    }

    public static NkColorf callocStack() {
        return NkColorf.callocStack(MemoryStack.stackGet());
    }

    public static NkColorf mallocStack(MemoryStack stack) {
        return NkColorf.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkColorf callocStack(MemoryStack stack) {
        return NkColorf.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkColorf.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkColorf.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkColorf.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkColorf.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)R);
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)G);
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)B);
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)A);
    }

    public static void nr(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)A, value);
    }

    static {
        Struct.Layout layout = NkColorf.__struct(NkColorf.__member(4), NkColorf.__member(4), NkColorf.__member(4), NkColorf.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkColorf, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkColorf newInstance(long address) {
            return new NkColorf(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float r() {
            return NkColorf.nr(this.address());
        }

        public float g() {
            return NkColorf.ng(this.address());
        }

        public float b() {
            return NkColorf.nb(this.address());
        }

        public float a() {
            return NkColorf.na(this.address());
        }

        public Buffer r(float value) {
            NkColorf.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            NkColorf.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            NkColorf.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            NkColorf.na(this.address(), value);
            return this;
        }
    }
}

