/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkPluginAlloc;
import org.lwjgl.nuklear.NkPluginAllocI;
import org.lwjgl.nuklear.NkPluginFree;
import org.lwjgl.nuklear.NkPluginFreeI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_allocator")
public class NkAllocator
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int ALLOC;
    public static final int MFREE;

    NkAllocator(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public NkAllocator(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkAllocator.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkAllocator.nuserdata(this.address());
    }

    public NkAllocator userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    @Nullable
    @NativeType(value="nk_plugin_alloc")
    public NkPluginAlloc alloc() {
        return NkAllocator.nalloc(this.address());
    }

    @Nullable
    @NativeType(value="nk_plugin_free")
    public NkPluginFree mfree() {
        return NkAllocator.nmfree(this.address());
    }

    public NkAllocator userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkAllocator.nuserdata(this.address(), value);
        return this;
    }

    public NkAllocator alloc(@Nullable @NativeType(value="nk_plugin_alloc") NkPluginAllocI value) {
        NkAllocator.nalloc(this.address(), value);
        return this;
    }

    public NkAllocator mfree(@Nullable @NativeType(value="nk_plugin_free") NkPluginFreeI value) {
        NkAllocator.nmfree(this.address(), value);
        return this;
    }

    public NkAllocator set(NkHandle userdata, NkPluginAllocI alloc, NkPluginFreeI mfree) {
        this.userdata(userdata);
        this.alloc(alloc);
        this.mfree(mfree);
        return this;
    }

    public NkAllocator set(NkAllocator src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkAllocator malloc() {
        return NkAllocator.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkAllocator calloc() {
        return NkAllocator.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkAllocator create() {
        return new NkAllocator(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkAllocator create(long address) {
        return new NkAllocator(address, null);
    }

    @Nullable
    public static NkAllocator createSafe(long address) {
        return address == 0L ? null : NkAllocator.create(address);
    }

    public static Buffer malloc(int capacity) {
        return NkAllocator.create(NkAllocator.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkAllocator.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(NkAllocator.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkAllocator.create(address, capacity);
    }

    public static NkAllocator mallocStack() {
        return NkAllocator.mallocStack(MemoryStack.stackGet());
    }

    public static NkAllocator callocStack() {
        return NkAllocator.callocStack(MemoryStack.stackGet());
    }

    public static NkAllocator mallocStack(MemoryStack stack) {
        return NkAllocator.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkAllocator callocStack(MemoryStack stack) {
        return NkAllocator.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkAllocator.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkAllocator.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkAllocator.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkAllocator.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    @Nullable
    public static NkPluginAlloc nalloc(long struct) {
        return NkPluginAlloc.createSafe(MemoryUtil.memGetAddress(struct + (long)ALLOC));
    }

    @Nullable
    public static NkPluginFree nmfree(long struct) {
        return NkPluginFree.createSafe(MemoryUtil.memGetAddress(struct + (long)MFREE));
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void nalloc(long struct, @Nullable NkPluginAllocI value) {
        MemoryUtil.memPutAddress(struct + (long)ALLOC, MemoryUtil.memAddressSafe(value));
    }

    public static void nmfree(long struct, @Nullable NkPluginFreeI value) {
        MemoryUtil.memPutAddress(struct + (long)MFREE, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = NkAllocator.__struct(NkAllocator.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkAllocator.__member(POINTER_SIZE), NkAllocator.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        ALLOC = layout.offsetof(1);
        MFREE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkAllocator, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkAllocator newInstance(long address) {
            return new NkAllocator(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkAllocator.nuserdata(this.address());
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        @Nullable
        @NativeType(value="nk_plugin_alloc")
        public NkPluginAlloc alloc() {
            return NkAllocator.nalloc(this.address());
        }

        @Nullable
        @NativeType(value="nk_plugin_free")
        public NkPluginFree mfree() {
            return NkAllocator.nmfree(this.address());
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkAllocator.nuserdata(this.address(), value);
            return this;
        }

        public Buffer alloc(@Nullable @NativeType(value="nk_plugin_alloc") NkPluginAllocI value) {
            NkAllocator.nalloc(this.address(), value);
            return this;
        }

        public Buffer mfree(@Nullable @NativeType(value="nk_plugin_free") NkPluginFreeI value) {
            NkAllocator.nmfree(this.address(), value);
            return this;
        }
    }
}

