/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class NVSync {
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE_NV = 12518;
    public static final int EGL_SYNC_STATUS_NV = 12519;
    public static final int EGL_SIGNALED_NV = 12520;
    public static final int EGL_UNSIGNALED_NV = 12521;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_NV = 1;
    public static final int EGL_ALREADY_SIGNALED_NV = 12522;
    public static final int EGL_TIMEOUT_EXPIRED_NV = 12523;
    public static final int EGL_CONDITION_SATISFIED_NV = 12524;
    public static final int EGL_SYNC_TYPE_NV = 12525;
    public static final int EGL_SYNC_CONDITION_NV = 12526;
    public static final int EGL_SYNC_FENCE_NV = 12527;
    public static final long EGL_FOREVER_NV = -1L;
    public static final long EGL_NO_SYNC_NV = 0L;

    protected NVSync() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateFenceSyncNV, caps.eglDestroySyncNV, caps.eglFenceNV, caps.eglClientWaitSyncNV, caps.eglSignalSyncNV, caps.eglGetSyncAttribNV);
    }

    public static long neglCreateFenceSyncNV(long dpy, int condition, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateFenceSyncNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPP(__functionAddress, dpy, condition, attrib_list);
    }

    @NativeType(value="EGLSyncNV")
    public static long eglCreateFenceSyncNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLenum") int condition, @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT(attrib_list, 12344);
        }
        return NVSync.neglCreateFenceSyncNV(dpy, condition, MemoryUtil.memAddress(attrib_list));
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglDestroySyncNV(@NativeType(value="EGLSyncNV") long sync) {
        long __functionAddress = EGL.getCapabilities().eglDestroySyncNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
        }
        return JNI.callPI(__functionAddress, sync) != 0;
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglFenceNV(@NativeType(value="EGLSyncNV") long sync) {
        long __functionAddress = EGL.getCapabilities().eglFenceNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
        }
        return JNI.callPI(__functionAddress, sync) != 0;
    }

    @NativeType(value="EGLint")
    public static int eglClientWaitSyncNV(@NativeType(value="EGLSyncNV") long sync, @NativeType(value="EGLint") int flags, @NativeType(value="EGLTimeNV") long timeout) {
        long __functionAddress = EGL.getCapabilities().eglClientWaitSyncNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
        }
        return JNI.callPJI(__functionAddress, sync, flags, timeout);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglSignalSyncNV(@NativeType(value="EGLSyncNV") long sync, @NativeType(value="EGLenum") int mode) {
        long __functionAddress = EGL.getCapabilities().eglSignalSyncNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
        }
        return JNI.callPI(__functionAddress, sync, mode) != 0;
    }

    public static int neglGetSyncAttribNV(long sync, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
        }
        return JNI.callPPI(__functionAddress, sync, attribute, value);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetSyncAttribNV(@NativeType(value="EGLSyncNV") long sync, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return NVSync.neglGetSyncAttribNV(sync, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    @NativeType(value="EGLSyncNV")
    public static long eglCreateFenceSyncNV(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLenum") int condition, @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateFenceSyncNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.checkNT(attrib_list, 12344);
        }
        return JNI.callPPP(__functionAddress, dpy, condition, attrib_list);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglGetSyncAttribNV(@NativeType(value="EGLSyncNV") long sync, @NativeType(value="EGLint") int attribute, @NativeType(value="EGLint *") int[] value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribNV;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
            Checks.check(value, 1);
        }
        return JNI.callPPI(__functionAddress, sync, attribute, value) != 0;
    }
}

