/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_texture_info_t")
public class BGFXTextureInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int STORAGESIZE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int NUMLAYERS;
    public static final int NUMMIPS;
    public static final int BITSPERPIXEL;
    public static final int CUBEMAP;

    BGFXTextureInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXTextureInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXTextureInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_texture_format_t")
    public int format() {
        return BGFXTextureInfo.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int storageSize() {
        return BGFXTextureInfo.nstorageSize(this.address());
    }

    @NativeType(value="uint16_t")
    public short width() {
        return BGFXTextureInfo.nwidth(this.address());
    }

    @NativeType(value="uint16_t")
    public short height() {
        return BGFXTextureInfo.nheight(this.address());
    }

    @NativeType(value="uint16_t")
    public short depth() {
        return BGFXTextureInfo.ndepth(this.address());
    }

    @NativeType(value="uint16_t")
    public short numLayers() {
        return BGFXTextureInfo.nnumLayers(this.address());
    }

    @NativeType(value="uint8_t")
    public byte numMips() {
        return BGFXTextureInfo.nnumMips(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bitsPerPixel() {
        return BGFXTextureInfo.nbitsPerPixel(this.address());
    }

    @NativeType(value="bool")
    public boolean cubeMap() {
        return BGFXTextureInfo.ncubeMap(this.address());
    }

    public static BGFXTextureInfo malloc() {
        return BGFXTextureInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXTextureInfo calloc() {
        return BGFXTextureInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXTextureInfo create() {
        return new BGFXTextureInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXTextureInfo create(long address) {
        return new BGFXTextureInfo(address, null);
    }

    @Nullable
    public static BGFXTextureInfo createSafe(long address) {
        return address == 0L ? null : BGFXTextureInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXTextureInfo.create(BGFXTextureInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXTextureInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXTextureInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXTextureInfo.create(address, capacity);
    }

    public static BGFXTextureInfo mallocStack() {
        return BGFXTextureInfo.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXTextureInfo callocStack() {
        return BGFXTextureInfo.callocStack(MemoryStack.stackGet());
    }

    public static BGFXTextureInfo mallocStack(MemoryStack stack) {
        return BGFXTextureInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTextureInfo callocStack(MemoryStack stack) {
        return BGFXTextureInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXTextureInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXTextureInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTextureInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTextureInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nstorageSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STORAGESIZE);
    }

    public static short nwidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)WIDTH);
    }

    public static short nheight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HEIGHT);
    }

    public static short ndepth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DEPTH);
    }

    public static short nnumLayers(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMLAYERS);
    }

    public static byte nnumMips(long struct) {
        return MemoryUtil.memGetByte(struct + (long)NUMMIPS);
    }

    public static byte nbitsPerPixel(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BITSPERPIXEL);
    }

    public static boolean ncubeMap(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CUBEMAP) != 0;
    }

    static {
        Struct.Layout layout = BGFXTextureInfo.__struct(BGFXTextureInfo.__member(4), BGFXTextureInfo.__member(4), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(1), BGFXTextureInfo.__member(1), BGFXTextureInfo.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        STORAGESIZE = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        DEPTH = layout.offsetof(4);
        NUMLAYERS = layout.offsetof(5);
        NUMMIPS = layout.offsetof(6);
        BITSPERPIXEL = layout.offsetof(7);
        CUBEMAP = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<BGFXTextureInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXTextureInfo newInstance(long address) {
            return new BGFXTextureInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="bgfx_texture_format_t")
        public int format() {
            return BGFXTextureInfo.nformat(this.address());
        }

        @NativeType(value="uint32_t")
        public int storageSize() {
            return BGFXTextureInfo.nstorageSize(this.address());
        }

        @NativeType(value="uint16_t")
        public short width() {
            return BGFXTextureInfo.nwidth(this.address());
        }

        @NativeType(value="uint16_t")
        public short height() {
            return BGFXTextureInfo.nheight(this.address());
        }

        @NativeType(value="uint16_t")
        public short depth() {
            return BGFXTextureInfo.ndepth(this.address());
        }

        @NativeType(value="uint16_t")
        public short numLayers() {
            return BGFXTextureInfo.nnumLayers(this.address());
        }

        @NativeType(value="uint8_t")
        public byte numMips() {
            return BGFXTextureInfo.nnumMips(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bitsPerPixel() {
            return BGFXTextureInfo.nbitsPerPixel(this.address());
        }

        @NativeType(value="bool")
        public boolean cubeMap() {
            return BGFXTextureInfo.ncubeMap(this.address());
        }
    }
}

