/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_resolution_t")
public class BGFXResolution
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int RESET;

    BGFXResolution(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXResolution(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXResolution.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int width() {
        return BGFXResolution.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return BGFXResolution.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int reset() {
        return BGFXResolution.nreset(this.address());
    }

    public BGFXResolution width(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nwidth(this.address(), value);
        return this;
    }

    public BGFXResolution height(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nheight(this.address(), value);
        return this;
    }

    public BGFXResolution reset(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nreset(this.address(), value);
        return this;
    }

    public BGFXResolution set(int width, int height, int reset) {
        this.width(width);
        this.height(height);
        this.reset(reset);
        return this;
    }

    public BGFXResolution set(BGFXResolution src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXResolution malloc() {
        return BGFXResolution.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXResolution calloc() {
        return BGFXResolution.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXResolution create() {
        return new BGFXResolution(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXResolution create(long address) {
        return new BGFXResolution(address, null);
    }

    @Nullable
    public static BGFXResolution createSafe(long address) {
        return address == 0L ? null : BGFXResolution.create(address);
    }

    public static BGFXResolution mallocStack() {
        return BGFXResolution.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXResolution callocStack() {
        return BGFXResolution.callocStack(MemoryStack.stackGet());
    }

    public static BGFXResolution mallocStack(MemoryStack stack) {
        return BGFXResolution.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXResolution callocStack(MemoryStack stack) {
        return BGFXResolution.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nreset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RESET);
    }

    public static void nwidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HEIGHT, value);
    }

    public static void nreset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RESET, value);
    }

    static {
        Struct.Layout layout = BGFXResolution.__struct(BGFXResolution.__member(4), BGFXResolution.__member(4), BGFXResolution.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        RESET = layout.offsetof(2);
    }
}

