/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_caps_gpu_t")
public class BGFXCapsGPU
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VENDORID;
    public static final int DEVICEID;

    BGFXCapsGPU(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXCapsGPU(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCapsGPU.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short vendorId() {
        return BGFXCapsGPU.nvendorId(this.address());
    }

    @NativeType(value="uint16_t")
    public short deviceId() {
        return BGFXCapsGPU.ndeviceId(this.address());
    }

    public static BGFXCapsGPU create(long address) {
        return new BGFXCapsGPU(address, null);
    }

    @Nullable
    public static BGFXCapsGPU createSafe(long address) {
        return address == 0L ? null : BGFXCapsGPU.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXCapsGPU.create(address, capacity);
    }

    public static short nvendorId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)VENDORID);
    }

    public static short ndeviceId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DEVICEID);
    }

    static {
        Struct.Layout layout = BGFXCapsGPU.__struct(BGFXCapsGPU.__member(2), BGFXCapsGPU.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VENDORID = layout.offsetof(0);
        DEVICEID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXCapsGPU, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXCapsGPU newInstance(long address) {
            return new BGFXCapsGPU(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="uint16_t")
        public short vendorId() {
            return BGFXCapsGPU.nvendorId(this.address());
        }

        @NativeType(value="uint16_t")
        public short deviceId() {
            return BGFXCapsGPU.ndeviceId(this.address());
        }
    }
}

