/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_attachment_t")
public class BGFXAttachment
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int MIP;
    public static final int LAYER;

    BGFXAttachment(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public BGFXAttachment(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXAttachment.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_texture_handle_t")
    public short handle() {
        return BGFXAttachment.nhandle(this.address());
    }

    @NativeType(value="uint16_t")
    public short mip() {
        return BGFXAttachment.nmip(this.address());
    }

    @NativeType(value="uint16_t")
    public short layer() {
        return BGFXAttachment.nlayer(this.address());
    }

    public BGFXAttachment handle(@NativeType(value="bgfx_texture_handle_t") short value) {
        BGFXAttachment.nhandle(this.address(), value);
        return this;
    }

    public BGFXAttachment mip(@NativeType(value="uint16_t") short value) {
        BGFXAttachment.nmip(this.address(), value);
        return this;
    }

    public BGFXAttachment layer(@NativeType(value="uint16_t") short value) {
        BGFXAttachment.nlayer(this.address(), value);
        return this;
    }

    public BGFXAttachment set(short handle, short mip, short layer) {
        this.handle(handle);
        this.mip(mip);
        this.layer(layer);
        return this;
    }

    public BGFXAttachment set(BGFXAttachment src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXAttachment malloc() {
        return BGFXAttachment.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXAttachment calloc() {
        return BGFXAttachment.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXAttachment create() {
        return new BGFXAttachment(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXAttachment create(long address) {
        return new BGFXAttachment(address, null);
    }

    @Nullable
    public static BGFXAttachment createSafe(long address) {
        return address == 0L ? null : BGFXAttachment.create(address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXAttachment.create(BGFXAttachment.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXAttachment.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BGFXAttachment.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXAttachment.create(address, capacity);
    }

    public static BGFXAttachment mallocStack() {
        return BGFXAttachment.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXAttachment callocStack() {
        return BGFXAttachment.callocStack(MemoryStack.stackGet());
    }

    public static BGFXAttachment mallocStack(MemoryStack stack) {
        return BGFXAttachment.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXAttachment callocStack(MemoryStack stack) {
        return BGFXAttachment.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXAttachment.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXAttachment.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXAttachment.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXAttachment.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nhandle(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HANDLE);
    }

    public static short nmip(long struct) {
        return MemoryUtil.memGetShort(struct + (long)MIP);
    }

    public static short nlayer(long struct) {
        return MemoryUtil.memGetShort(struct + (long)LAYER);
    }

    public static void nhandle(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)HANDLE, value);
    }

    public static void nmip(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)MIP, value);
    }

    public static void nlayer(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)LAYER, value);
    }

    static {
        Struct.Layout layout = BGFXAttachment.__struct(BGFXAttachment.__member(2), BGFXAttachment.__member(2), BGFXAttachment.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        MIP = layout.offsetof(1);
        LAYER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<BGFXAttachment, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXAttachment newInstance(long address) {
            return new BGFXAttachment(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="bgfx_texture_handle_t")
        public short handle() {
            return BGFXAttachment.nhandle(this.address());
        }

        @NativeType(value="uint16_t")
        public short mip() {
            return BGFXAttachment.nmip(this.address());
        }

        @NativeType(value="uint16_t")
        public short layer() {
            return BGFXAttachment.nlayer(this.address());
        }

        public Buffer handle(@NativeType(value="bgfx_texture_handle_t") short value) {
            BGFXAttachment.nhandle(this.address(), value);
            return this;
        }

        public Buffer mip(@NativeType(value="uint16_t") short value) {
            BGFXAttachment.nmip(this.address(), value);
            return this;
        }

        public Buffer layer(@NativeType(value="uint16_t") short value) {
            BGFXAttachment.nlayer(this.address(), value);
            return this;
        }
    }
}

