/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiVector3D")
public class AIVector3D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    AIVector3D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIVector3D(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIVector3D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return AIVector3D.nx(this.address());
    }

    public float y() {
        return AIVector3D.ny(this.address());
    }

    public float z() {
        return AIVector3D.nz(this.address());
    }

    public AIVector3D x(float value) {
        AIVector3D.nx(this.address(), value);
        return this;
    }

    public AIVector3D y(float value) {
        AIVector3D.ny(this.address(), value);
        return this;
    }

    public AIVector3D z(float value) {
        AIVector3D.nz(this.address(), value);
        return this;
    }

    public AIVector3D set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public AIVector3D set(AIVector3D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIVector3D malloc() {
        return AIVector3D.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIVector3D calloc() {
        return AIVector3D.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIVector3D create() {
        return new AIVector3D(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIVector3D create(long address) {
        return new AIVector3D(address, null);
    }

    @Nullable
    public static AIVector3D createSafe(long address) {
        return address == 0L ? null : AIVector3D.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIVector3D.create(AIVector3D.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIVector3D.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIVector3D.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIVector3D.create(address, capacity);
    }

    public static AIVector3D mallocStack() {
        return AIVector3D.mallocStack(MemoryStack.stackGet());
    }

    public static AIVector3D callocStack() {
        return AIVector3D.callocStack(MemoryStack.stackGet());
    }

    public static AIVector3D mallocStack(MemoryStack stack) {
        return AIVector3D.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIVector3D callocStack(MemoryStack stack) {
        return AIVector3D.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIVector3D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIVector3D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVector3D.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVector3D.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = AIVector3D.__struct(AIVector3D.__member(4), AIVector3D.__member(4), AIVector3D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIVector3D, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIVector3D newInstance(long address) {
            return new AIVector3D(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return AIVector3D.nx(this.address());
        }

        public float y() {
            return AIVector3D.ny(this.address());
        }

        public float z() {
            return AIVector3D.nz(this.address());
        }

        public Buffer x(float value) {
            AIVector3D.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            AIVector3D.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            AIVector3D.nz(this.address(), value);
            return this;
        }
    }
}

