/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiTexel")
public class AITexel
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int B;
    public static final int G;
    public static final int R;
    public static final int A;

    AITexel(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AITexel(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AITexel.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char")
    public byte b() {
        return AITexel.nb(this.address());
    }

    @NativeType(value="unsigned char")
    public byte g() {
        return AITexel.ng(this.address());
    }

    @NativeType(value="unsigned char")
    public byte r() {
        return AITexel.nr(this.address());
    }

    @NativeType(value="unsigned char")
    public byte a() {
        return AITexel.na(this.address());
    }

    public static AITexel create(long address) {
        return new AITexel(address, null);
    }

    @Nullable
    public static AITexel createSafe(long address) {
        return address == 0L ? null : AITexel.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AITexel.create(address, capacity);
    }

    public static byte nb(long struct) {
        return MemoryUtil.memGetByte(struct + (long)B);
    }

    public static byte ng(long struct) {
        return MemoryUtil.memGetByte(struct + (long)G);
    }

    public static byte nr(long struct) {
        return MemoryUtil.memGetByte(struct + (long)R);
    }

    public static byte na(long struct) {
        return MemoryUtil.memGetByte(struct + (long)A);
    }

    static {
        Struct.Layout layout = AITexel.__struct(AITexel.__member(1), AITexel.__member(1), AITexel.__member(1), AITexel.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        B = layout.offsetof(0);
        G = layout.offsetof(1);
        R = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AITexel, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AITexel newInstance(long address) {
            return new AITexel(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned char")
        public byte b() {
            return AITexel.nb(this.address());
        }

        @NativeType(value="unsigned char")
        public byte g() {
            return AITexel.ng(this.address());
        }

        @NativeType(value="unsigned char")
        public byte r() {
            return AITexel.nr(this.address());
        }

        @NativeType(value="unsigned char")
        public byte a() {
            return AITexel.na(this.address());
        }
    }
}

