/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiQuaternion")
public class AIQuaternion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    AIQuaternion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIQuaternion(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIQuaternion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float w() {
        return AIQuaternion.nw(this.address());
    }

    public float x() {
        return AIQuaternion.nx(this.address());
    }

    public float y() {
        return AIQuaternion.ny(this.address());
    }

    public float z() {
        return AIQuaternion.nz(this.address());
    }

    public AIQuaternion w(float value) {
        AIQuaternion.nw(this.address(), value);
        return this;
    }

    public AIQuaternion x(float value) {
        AIQuaternion.nx(this.address(), value);
        return this;
    }

    public AIQuaternion y(float value) {
        AIQuaternion.ny(this.address(), value);
        return this;
    }

    public AIQuaternion z(float value) {
        AIQuaternion.nz(this.address(), value);
        return this;
    }

    public AIQuaternion set(float w, float x, float y, float z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public AIQuaternion set(AIQuaternion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIQuaternion malloc() {
        return AIQuaternion.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIQuaternion calloc() {
        return AIQuaternion.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIQuaternion create() {
        return new AIQuaternion(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIQuaternion create(long address) {
        return new AIQuaternion(address, null);
    }

    @Nullable
    public static AIQuaternion createSafe(long address) {
        return address == 0L ? null : AIQuaternion.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIQuaternion.create(AIQuaternion.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIQuaternion.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIQuaternion.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIQuaternion.create(address, capacity);
    }

    public static AIQuaternion mallocStack() {
        return AIQuaternion.mallocStack(MemoryStack.stackGet());
    }

    public static AIQuaternion callocStack() {
        return AIQuaternion.callocStack(MemoryStack.stackGet());
    }

    public static AIQuaternion mallocStack(MemoryStack stack) {
        return AIQuaternion.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIQuaternion callocStack(MemoryStack stack) {
        return AIQuaternion.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIQuaternion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIQuaternion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIQuaternion.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIQuaternion.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)W, value);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = AIQuaternion.__struct(AIQuaternion.__member(4), AIQuaternion.__member(4), AIQuaternion.__member(4), AIQuaternion.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIQuaternion, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIQuaternion newInstance(long address) {
            return new AIQuaternion(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float w() {
            return AIQuaternion.nw(this.address());
        }

        public float x() {
            return AIQuaternion.nx(this.address());
        }

        public float y() {
            return AIQuaternion.ny(this.address());
        }

        public float z() {
            return AIQuaternion.nz(this.address());
        }

        public Buffer w(float value) {
            AIQuaternion.nw(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            AIQuaternion.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            AIQuaternion.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            AIQuaternion.nz(this.address(), value);
            return this;
        }
    }
}

