/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiPropertyStore")
public class AIPropertyStore
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SENTINEL;

    AIPropertyStore(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIPropertyStore(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIPropertyStore.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char")
    public byte sentinel() {
        return AIPropertyStore.nsentinel(this.address());
    }

    public AIPropertyStore sentinel(@NativeType(value="char") byte value) {
        AIPropertyStore.nsentinel(this.address(), value);
        return this;
    }

    public AIPropertyStore set(AIPropertyStore src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIPropertyStore malloc() {
        return AIPropertyStore.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIPropertyStore calloc() {
        return AIPropertyStore.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIPropertyStore create() {
        return new AIPropertyStore(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIPropertyStore create(long address) {
        return new AIPropertyStore(address, null);
    }

    @Nullable
    public static AIPropertyStore createSafe(long address) {
        return address == 0L ? null : AIPropertyStore.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIPropertyStore.create(AIPropertyStore.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIPropertyStore.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIPropertyStore.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIPropertyStore.create(address, capacity);
    }

    public static AIPropertyStore mallocStack() {
        return AIPropertyStore.mallocStack(MemoryStack.stackGet());
    }

    public static AIPropertyStore callocStack() {
        return AIPropertyStore.callocStack(MemoryStack.stackGet());
    }

    public static AIPropertyStore mallocStack(MemoryStack stack) {
        return AIPropertyStore.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIPropertyStore callocStack(MemoryStack stack) {
        return AIPropertyStore.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIPropertyStore.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIPropertyStore.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIPropertyStore.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIPropertyStore.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nsentinel(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SENTINEL);
    }

    public static void nsentinel(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)SENTINEL, value);
    }

    static {
        Struct.Layout layout = AIPropertyStore.__struct(AIPropertyStore.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SENTINEL = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<AIPropertyStore, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIPropertyStore newInstance(long address) {
            return new AIPropertyStore(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char")
        public byte sentinel() {
            return AIPropertyStore.nsentinel(this.address());
        }

        public Buffer sentinel(@NativeType(value="char") byte value) {
            AIPropertyStore.nsentinel(this.address(), value);
            return this;
        }
    }
}

