/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMemoryInfo")
public class AIMemoryInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURES;
    public static final int MATERIALS;
    public static final int MESHES;
    public static final int NODES;
    public static final int ANIMATIONS;
    public static final int CAMERAS;
    public static final int LIGHTS;
    public static final int TOTAL;

    AIMemoryInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIMemoryInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIMemoryInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int textures() {
        return AIMemoryInfo.ntextures(this.address());
    }

    @NativeType(value="unsigned int")
    public int materials() {
        return AIMemoryInfo.nmaterials(this.address());
    }

    @NativeType(value="unsigned int")
    public int meshes() {
        return AIMemoryInfo.nmeshes(this.address());
    }

    @NativeType(value="unsigned int")
    public int nodes() {
        return AIMemoryInfo.nnodes(this.address());
    }

    @NativeType(value="unsigned int")
    public int animations() {
        return AIMemoryInfo.nanimations(this.address());
    }

    @NativeType(value="unsigned int")
    public int cameras() {
        return AIMemoryInfo.ncameras(this.address());
    }

    @NativeType(value="unsigned int")
    public int lights() {
        return AIMemoryInfo.nlights(this.address());
    }

    @NativeType(value="unsigned int")
    public int total() {
        return AIMemoryInfo.ntotal(this.address());
    }

    public static AIMemoryInfo malloc() {
        return AIMemoryInfo.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIMemoryInfo calloc() {
        return AIMemoryInfo.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIMemoryInfo create() {
        return new AIMemoryInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIMemoryInfo create(long address) {
        return new AIMemoryInfo(address, null);
    }

    @Nullable
    public static AIMemoryInfo createSafe(long address) {
        return address == 0L ? null : AIMemoryInfo.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIMemoryInfo.create(AIMemoryInfo.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMemoryInfo.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIMemoryInfo.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIMemoryInfo.create(address, capacity);
    }

    public static AIMemoryInfo mallocStack() {
        return AIMemoryInfo.mallocStack(MemoryStack.stackGet());
    }

    public static AIMemoryInfo callocStack() {
        return AIMemoryInfo.callocStack(MemoryStack.stackGet());
    }

    public static AIMemoryInfo mallocStack(MemoryStack stack) {
        return AIMemoryInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMemoryInfo callocStack(MemoryStack stack) {
        return AIMemoryInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMemoryInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMemoryInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMemoryInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMemoryInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntextures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXTURES);
    }

    public static int nmaterials(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MATERIALS);
    }

    public static int nmeshes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MESHES);
    }

    public static int nnodes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NODES);
    }

    public static int nanimations(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ANIMATIONS);
    }

    public static int ncameras(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CAMERAS);
    }

    public static int nlights(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LIGHTS);
    }

    public static int ntotal(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOTAL);
    }

    static {
        Struct.Layout layout = AIMemoryInfo.__struct(AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4), AIMemoryInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURES = layout.offsetof(0);
        MATERIALS = layout.offsetof(1);
        MESHES = layout.offsetof(2);
        NODES = layout.offsetof(3);
        ANIMATIONS = layout.offsetof(4);
        CAMERAS = layout.offsetof(5);
        LIGHTS = layout.offsetof(6);
        TOTAL = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AIMemoryInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIMemoryInfo newInstance(long address) {
            return new AIMemoryInfo(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned int")
        public int textures() {
            return AIMemoryInfo.ntextures(this.address());
        }

        @NativeType(value="unsigned int")
        public int materials() {
            return AIMemoryInfo.nmaterials(this.address());
        }

        @NativeType(value="unsigned int")
        public int meshes() {
            return AIMemoryInfo.nmeshes(this.address());
        }

        @NativeType(value="unsigned int")
        public int nodes() {
            return AIMemoryInfo.nnodes(this.address());
        }

        @NativeType(value="unsigned int")
        public int animations() {
            return AIMemoryInfo.nanimations(this.address());
        }

        @NativeType(value="unsigned int")
        public int cameras() {
            return AIMemoryInfo.ncameras(this.address());
        }

        @NativeType(value="unsigned int")
        public int lights() {
            return AIMemoryInfo.nlights(this.address());
        }

        @NativeType(value="unsigned int")
        public int total() {
            return AIMemoryInfo.ntotal(this.address());
        }
    }
}

