/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiImporterDesc")
public class AIImporterDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MAUTHOR;
    public static final int MMAINTAINER;
    public static final int MCOMMENTS;
    public static final int MFLAGS;
    public static final int MMINMAJOR;
    public static final int MMINMINOR;
    public static final int MMAXMAJOR;
    public static final int MMAXMINOR;
    public static final int MFILEEXTENSIONS;

    AIImporterDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIImporterDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIImporterDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer mName() {
        return AIImporterDesc.nmName(this.address());
    }

    @NativeType(value="char const *")
    public String mNameString() {
        return AIImporterDesc.nmNameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mAuthor() {
        return AIImporterDesc.nmAuthor(this.address());
    }

    @NativeType(value="char const *")
    public String mAuthorString() {
        return AIImporterDesc.nmAuthorString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mMaintainer() {
        return AIImporterDesc.nmMaintainer(this.address());
    }

    @NativeType(value="char const *")
    public String mMaintainerString() {
        return AIImporterDesc.nmMaintainerString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mComments() {
        return AIImporterDesc.nmComments(this.address());
    }

    @NativeType(value="char const *")
    public String mCommentsString() {
        return AIImporterDesc.nmCommentsString(this.address());
    }

    @NativeType(value="unsigned int")
    public int mFlags() {
        return AIImporterDesc.nmFlags(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMinMajor() {
        return AIImporterDesc.nmMinMajor(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMinMinor() {
        return AIImporterDesc.nmMinMinor(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMaxMajor() {
        return AIImporterDesc.nmMaxMajor(this.address());
    }

    @NativeType(value="unsigned int")
    public int mMaxMinor() {
        return AIImporterDesc.nmMaxMinor(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer mFileExtensions() {
        return AIImporterDesc.nmFileExtensions(this.address());
    }

    @NativeType(value="char const *")
    public String mFileExtensionsString() {
        return AIImporterDesc.nmFileExtensionsString(this.address());
    }

    public AIImporterDesc mName(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmName(this.address(), value);
        return this;
    }

    public AIImporterDesc mAuthor(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmAuthor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMaintainer(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmMaintainer(this.address(), value);
        return this;
    }

    public AIImporterDesc mComments(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmComments(this.address(), value);
        return this;
    }

    public AIImporterDesc mFlags(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmFlags(this.address(), value);
        return this;
    }

    public AIImporterDesc mMinMajor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMinMajor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMinMinor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMinMinor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMaxMajor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMaxMajor(this.address(), value);
        return this;
    }

    public AIImporterDesc mMaxMinor(@NativeType(value="unsigned int") int value) {
        AIImporterDesc.nmMaxMinor(this.address(), value);
        return this;
    }

    public AIImporterDesc mFileExtensions(@NativeType(value="char const *") ByteBuffer value) {
        AIImporterDesc.nmFileExtensions(this.address(), value);
        return this;
    }

    public AIImporterDesc set(ByteBuffer mName, ByteBuffer mAuthor, ByteBuffer mMaintainer, ByteBuffer mComments, int mFlags, int mMinMajor, int mMinMinor, int mMaxMajor, int mMaxMinor, ByteBuffer mFileExtensions) {
        this.mName(mName);
        this.mAuthor(mAuthor);
        this.mMaintainer(mMaintainer);
        this.mComments(mComments);
        this.mFlags(mFlags);
        this.mMinMajor(mMinMajor);
        this.mMinMinor(mMinMinor);
        this.mMaxMajor(mMaxMajor);
        this.mMaxMinor(mMaxMinor);
        this.mFileExtensions(mFileExtensions);
        return this;
    }

    public AIImporterDesc set(AIImporterDesc src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIImporterDesc malloc() {
        return AIImporterDesc.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIImporterDesc calloc() {
        return AIImporterDesc.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIImporterDesc create() {
        return new AIImporterDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIImporterDesc create(long address) {
        return new AIImporterDesc(address, null);
    }

    @Nullable
    public static AIImporterDesc createSafe(long address) {
        return address == 0L ? null : AIImporterDesc.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIImporterDesc.create(AIImporterDesc.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIImporterDesc.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIImporterDesc.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIImporterDesc.create(address, capacity);
    }

    public static AIImporterDesc mallocStack() {
        return AIImporterDesc.mallocStack(MemoryStack.stackGet());
    }

    public static AIImporterDesc callocStack() {
        return AIImporterDesc.callocStack(MemoryStack.stackGet());
    }

    public static AIImporterDesc mallocStack(MemoryStack stack) {
        return AIImporterDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIImporterDesc callocStack(MemoryStack stack) {
        return AIImporterDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIImporterDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIImporterDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIImporterDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIImporterDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nmName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)MNAME));
    }

    public static String nmNameString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)MNAME));
    }

    public static ByteBuffer nmAuthor(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)MAUTHOR));
    }

    public static String nmAuthorString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)MAUTHOR));
    }

    public static ByteBuffer nmMaintainer(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)MMAINTAINER));
    }

    public static String nmMaintainerString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)MMAINTAINER));
    }

    public static ByteBuffer nmComments(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)MCOMMENTS));
    }

    public static String nmCommentsString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)MCOMMENTS));
    }

    public static int nmFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MFLAGS);
    }

    public static int nmMinMajor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MMINMAJOR);
    }

    public static int nmMinMinor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MMINMINOR);
    }

    public static int nmMaxMajor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MMAXMAJOR);
    }

    public static int nmMaxMinor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MMAXMINOR);
    }

    public static ByteBuffer nmFileExtensions(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)MFILEEXTENSIONS));
    }

    public static String nmFileExtensionsString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)MFILEEXTENSIONS));
    }

    public static void nmName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)MNAME, MemoryUtil.memAddress(value));
    }

    public static void nmAuthor(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)MAUTHOR, MemoryUtil.memAddress(value));
    }

    public static void nmMaintainer(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)MMAINTAINER, MemoryUtil.memAddress(value));
    }

    public static void nmComments(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)MCOMMENTS, MemoryUtil.memAddress(value));
    }

    public static void nmFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MFLAGS, value);
    }

    public static void nmMinMajor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MMINMAJOR, value);
    }

    public static void nmMinMinor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MMINMINOR, value);
    }

    public static void nmMaxMajor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MMAXMAJOR, value);
    }

    public static void nmMaxMinor(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MMAXMINOR, value);
    }

    public static void nmFileExtensions(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)MFILEEXTENSIONS, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MNAME));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MAUTHOR));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MMAINTAINER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MCOMMENTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MFILEEXTENSIONS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIImporterDesc.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIImporterDesc.__struct(AIImporterDesc.__member(POINTER_SIZE), AIImporterDesc.__member(POINTER_SIZE), AIImporterDesc.__member(POINTER_SIZE), AIImporterDesc.__member(POINTER_SIZE), AIImporterDesc.__member(4), AIImporterDesc.__member(4), AIImporterDesc.__member(4), AIImporterDesc.__member(4), AIImporterDesc.__member(4), AIImporterDesc.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MAUTHOR = layout.offsetof(1);
        MMAINTAINER = layout.offsetof(2);
        MCOMMENTS = layout.offsetof(3);
        MFLAGS = layout.offsetof(4);
        MMINMAJOR = layout.offsetof(5);
        MMINMINOR = layout.offsetof(6);
        MMAXMAJOR = layout.offsetof(7);
        MMAXMINOR = layout.offsetof(8);
        MFILEEXTENSIONS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<AIImporterDesc, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIImporterDesc newInstance(long address) {
            return new AIImporterDesc(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="char const *")
        public ByteBuffer mName() {
            return AIImporterDesc.nmName(this.address());
        }

        @NativeType(value="char const *")
        public String mNameString() {
            return AIImporterDesc.nmNameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mAuthor() {
            return AIImporterDesc.nmAuthor(this.address());
        }

        @NativeType(value="char const *")
        public String mAuthorString() {
            return AIImporterDesc.nmAuthorString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mMaintainer() {
            return AIImporterDesc.nmMaintainer(this.address());
        }

        @NativeType(value="char const *")
        public String mMaintainerString() {
            return AIImporterDesc.nmMaintainerString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mComments() {
            return AIImporterDesc.nmComments(this.address());
        }

        @NativeType(value="char const *")
        public String mCommentsString() {
            return AIImporterDesc.nmCommentsString(this.address());
        }

        @NativeType(value="unsigned int")
        public int mFlags() {
            return AIImporterDesc.nmFlags(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMinMajor() {
            return AIImporterDesc.nmMinMajor(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMinMinor() {
            return AIImporterDesc.nmMinMinor(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMaxMajor() {
            return AIImporterDesc.nmMaxMajor(this.address());
        }

        @NativeType(value="unsigned int")
        public int mMaxMinor() {
            return AIImporterDesc.nmMaxMinor(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer mFileExtensions() {
            return AIImporterDesc.nmFileExtensions(this.address());
        }

        @NativeType(value="char const *")
        public String mFileExtensionsString() {
            return AIImporterDesc.nmFileExtensionsString(this.address());
        }

        public Buffer mName(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmName(this.address(), value);
            return this;
        }

        public Buffer mAuthor(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmAuthor(this.address(), value);
            return this;
        }

        public Buffer mMaintainer(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmMaintainer(this.address(), value);
            return this;
        }

        public Buffer mComments(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmComments(this.address(), value);
            return this;
        }

        public Buffer mFlags(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmFlags(this.address(), value);
            return this;
        }

        public Buffer mMinMajor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMinMajor(this.address(), value);
            return this;
        }

        public Buffer mMinMinor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMinMinor(this.address(), value);
            return this;
        }

        public Buffer mMaxMajor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMaxMajor(this.address(), value);
            return this;
        }

        public Buffer mMaxMinor(@NativeType(value="unsigned int") int value) {
            AIImporterDesc.nmMaxMinor(this.address(), value);
            return this;
        }

        public Buffer mFileExtensions(@NativeType(value="char const *") ByteBuffer value) {
            AIImporterDesc.nmFileExtensions(this.address(), value);
            return this;
        }
    }
}

