/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVertexWeight;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiBone")
public class AIBone
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMWEIGHTS;
    public static final int MWEIGHTS;
    public static final int MOFFSETMATRIX;

    AIBone(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public AIBone(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIBone.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIBone.nmName(this.address());
    }

    public AIBone mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    @NativeType(value="unsigned int")
    public int mNumWeights() {
        return AIBone.nmNumWeights(this.address());
    }

    @NativeType(value="struct aiVertexWeight *")
    public AIVertexWeight.Buffer mWeights() {
        return AIBone.nmWeights(this.address());
    }

    @NativeType(value="struct aiMatrix4x4")
    public AIMatrix4x4 mOffsetMatrix() {
        return AIBone.nmOffsetMatrix(this.address());
    }

    public AIBone mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
        consumer.accept(this.mOffsetMatrix());
        return this;
    }

    public AIBone mName(@NativeType(value="struct aiString") AIString value) {
        AIBone.nmName(this.address(), value);
        return this;
    }

    public AIBone mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
        AIBone.nmWeights(this.address(), value);
        return this;
    }

    public AIBone mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
        AIBone.nmOffsetMatrix(this.address(), value);
        return this;
    }

    public AIBone set(AIString mName, AIVertexWeight.Buffer mWeights, AIMatrix4x4 mOffsetMatrix) {
        this.mName(mName);
        this.mWeights(mWeights);
        this.mOffsetMatrix(mOffsetMatrix);
        return this;
    }

    public AIBone set(AIBone src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIBone malloc() {
        return AIBone.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIBone calloc() {
        return AIBone.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIBone create() {
        return new AIBone(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIBone create(long address) {
        return new AIBone(address, null);
    }

    @Nullable
    public static AIBone createSafe(long address) {
        return address == 0L ? null : AIBone.create(address);
    }

    public static Buffer malloc(int capacity) {
        return AIBone.create(AIBone.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIBone.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(AIBone.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIBone.create(address, capacity);
    }

    public static AIBone mallocStack() {
        return AIBone.mallocStack(MemoryStack.stackGet());
    }

    public static AIBone callocStack() {
        return AIBone.callocStack(MemoryStack.stackGet());
    }

    public static AIBone mallocStack(MemoryStack stack) {
        return AIBone.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIBone callocStack(MemoryStack stack) {
        return AIBone.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIBone.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIBone.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIBone.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIBone.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumWeights(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMWEIGHTS);
    }

    public static AIVertexWeight.Buffer nmWeights(long struct) {
        return AIVertexWeight.create(MemoryUtil.memGetAddress(struct + (long)MWEIGHTS), AIBone.nmNumWeights(struct));
    }

    public static AIMatrix4x4 nmOffsetMatrix(long struct) {
        return AIMatrix4x4.create(struct + (long)MOFFSETMATRIX);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmNumWeights(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMWEIGHTS, value);
    }

    public static void nmWeights(long struct, AIVertexWeight.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MWEIGHTS, value.address());
        AIBone.nmNumWeights(struct, value.remaining());
    }

    public static void nmOffsetMatrix(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MOFFSETMATRIX, AIMatrix4x4.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MWEIGHTS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIBone.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIBone.__struct(AIBone.__member(AIString.SIZEOF, AIString.ALIGNOF), AIBone.__member(4), AIBone.__member(POINTER_SIZE), AIBone.__member(AIMatrix4x4.SIZEOF, AIMatrix4x4.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMWEIGHTS = layout.offsetof(1);
        MWEIGHTS = layout.offsetof(2);
        MOFFSETMATRIX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIBone, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIBone newInstance(long address) {
            return new AIBone(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIBone.nmName(this.address());
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        @NativeType(value="unsigned int")
        public int mNumWeights() {
            return AIBone.nmNumWeights(this.address());
        }

        @NativeType(value="struct aiVertexWeight *")
        public AIVertexWeight.Buffer mWeights() {
            return AIBone.nmWeights(this.address());
        }

        @NativeType(value="struct aiMatrix4x4")
        public AIMatrix4x4 mOffsetMatrix() {
            return AIBone.nmOffsetMatrix(this.address());
        }

        public Buffer mOffsetMatrix(Consumer<AIMatrix4x4> consumer) {
            consumer.accept(this.mOffsetMatrix());
            return this;
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIBone.nmName(this.address(), value);
            return this;
        }

        public Buffer mWeights(@NativeType(value="struct aiVertexWeight *") AIVertexWeight.Buffer value) {
            AIBone.nmWeights(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
            AIBone.nmOffsetMatrix(this.address(), value);
            return this;
        }
    }
}

