/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.joml.internal.MemUtil;
import org.joml.internal.Options;
import org.joml.internal.Runtime;

public class Vector3i
implements Externalizable,
Vector3ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;

    public Vector3i() {
    }

    public Vector3i(int d) {
        this(d, d, d);
    }

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(Vector3ic v) {
        this(v.x(), v.y(), v.z());
    }

    public Vector3i(Vector2ic v, int z) {
        this(v.x(), v.y(), z);
    }

    public Vector3i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3i(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector3i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3i(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    private Vector3i thisOrNew() {
        return this;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Vector3i set(Vector3ic v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        return this;
    }

    public Vector3i set(Vector3dc v) {
        return this.set((int)v.x(), (int)v.y(), (int)v.z());
    }

    public Vector3i set(Vector2ic v, int z) {
        return this.set(v.x(), v.y(), z);
    }

    public Vector3i set(int d) {
        return this.set(d, d, d);
    }

    public Vector3i set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3i set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3i set(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3i setFromAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.get(this, address);
        return this;
    }

    public int get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3i setComponent(int component, int value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector3ic getToAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.put(this, address);
        return this;
    }

    public Vector3i sub(Vector3ic v) {
        return this.sub(v.x(), v.y(), v.z(), this.thisOrNew());
    }

    public Vector3i sub(Vector3ic v, Vector3i dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        dest.z = this.z - v.z();
        return dest;
    }

    public Vector3i sub(int x, int y, int z) {
        return this.sub(x, y, z, this.thisOrNew());
    }

    public Vector3i sub(int x, int y, int z, Vector3i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        return dest;
    }

    public Vector3i add(Vector3ic v) {
        return this.add(v.x(), v.y(), v.z(), this.thisOrNew());
    }

    public Vector3i add(Vector3ic v, Vector3i dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        dest.z = this.z + v.z();
        return dest;
    }

    public Vector3i add(int x, int y, int z) {
        return this.add(x, y, z, this.thisOrNew());
    }

    public Vector3i add(int x, int y, int z, Vector3i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        return dest;
    }

    public Vector3i mul(int scalar) {
        return this.mul(scalar, this.thisOrNew());
    }

    public Vector3i mul(int scalar, Vector3i dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        return dest;
    }

    public Vector3i mul(Vector3ic v) {
        return this.mul(v.x(), v.y(), v.z(), this.thisOrNew());
    }

    public Vector3i mul(Vector3ic v, Vector3i dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        return dest;
    }

    public Vector3i mul(int x, int y, int z) {
        return this.mul(x, y, z, this.thisOrNew());
    }

    public Vector3i mul(int x, int y, int z, Vector3i dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector3ic v) {
        return this.distance(v.x(), v.y(), v.z());
    }

    public double distance(int x, int y, int z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public long distanceSquared(Vector3ic v) {
        return this.distanceSquared(v.x(), v.y(), v.z());
    }

    public long distanceSquared(int x, int y, int z) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public Vector3i zero() {
        return this.thisOrNew().set(0, 0, 0);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
    }

    public Vector3i negate() {
        return this.negate(this.thisOrNew());
    }

    public Vector3i negate(Vector3i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public Vector3i min(Vector3ic v) {
        return this.min(v, this.thisOrNew());
    }

    public Vector3i min(Vector3ic v, Vector3i dest) {
        dest.x = this.x < v.x() ? this.x : v.x();
        dest.y = this.y < v.y() ? this.y : v.y();
        dest.z = this.z < v.z() ? this.z : v.z();
        return this;
    }

    public Vector3i max(Vector3ic v) {
        return this.max(v, this.thisOrNew());
    }

    public Vector3i max(Vector3ic v, Vector3i dest) {
        dest.x = this.x > v.x() ? this.x : v.x();
        dest.y = this.y > v.y() ? this.y : v.y();
        dest.z = this.z > v.z() ? this.z : v.z();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3i other = (Vector3i)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

