/*
 * Decompiled with CFR 0.152.
 */
package game.weapons;

import engine.EnigUtils;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Main;
import game.Player;
import game.Shaders;
import game.Weapon;
import game.WeaponType;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class Shield
extends Weapon {
    public static Texture[] attackFrames;
    public static VAO attackVAO;

    public Shield(Player p) {
        super(p);
        this.type = WeaponType.shield;
    }

    @Override
    public void renderAttack(Matrix4f matrix) {
        Shaders.attackShader.enable();
        Shaders.attackShader.setUniform(0, 0, matrix.rotateZ(this.attackAngle));
        if (this.burning) {
            Shaders.attackShader.setUniform(2, 0, 1.0f, 0.6f, 0.22f);
        } else {
            Shaders.attackShader.setUniform(2, 0, 0.8f, 0.0f, 0.0f);
        }
        if (this.attackFrame == 16) {
            attackFrames[0].bind();
        } else {
            attackFrames[5 - this.attackFrame / 3].bind();
        }
        attackVAO.fullRender();
    }

    @Override
    public void renderIdle(Matrix4f mat) {
        if (this.attackFrame > 3) {
            float frameProgress = 1.0f - ((float)this.attackFrame - 3.0f) / 13.0f;
            Shaders.textureShader.setUniform(0, 0, mat.rotateZ(-1.5707964f).scale(0.5f + frameProgress * frameProgress).translate(0.0f, 5.0f + 4.0f * frameProgress, 0.0f));
        } else {
            float frameProgress = ((float)this.attackFrame - 3.0f) / 13.0f + 1.0f;
            Shaders.textureShader.setUniform(0, 0, mat.rotateZ(-1.5707964f).scale(0.5f + frameProgress * 0.5f).translate(0.0f, 5.0f + 4.0f * frameProgress, 0.0f));
        }
        this.bindTexture();
        Main.entityObj.drawTriangles();
    }

    @Override
    public boolean attackHits(Vector2f position, Vector2f player) {
        float angleDiff;
        float progress;
        Vector2f change = position.sub(player, new Vector2f());
        float distance = change.length();
        if (distance < (progress = 20.0f * (1.0f - ((float)this.attackFrame - 3.0f) / 13.0f)) && (double)(angleDiff = EnigUtils.compareAngles(this.attackAngle, (float)Math.atan2(position.y - player.y, position.x - player.x))) < 1.5807963265713791) {
            if (this.burning) {
                this.durability *= 0.95f;
                return true;
            }
            Vector2f nPos = change.normalize(progress).add(player);
            position.x = nPos.x;
            position.y = nPos.y;
        }
        return false;
    }

    @Override
    public float maxDurability() {
        return 30.0f;
    }

    public static void loadFrames() {
        attackFrames = new Texture[5];
        for (int i = 0; i < 5; ++i) {
            Shield.attackFrames[i] = new Texture("res/textures/weaponAnims/shield/" + i + ".png");
        }
        attackVAO = new VAO(-5.0f, -15.0f, 20.0f, 30.0f);
    }
}

