/*
 * Decompiled with CFR 0.152.
 */
package game.weapons;

import engine.EnigUtils;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Main;
import game.Player;
import game.Shaders;
import game.Weapon;
import game.WeaponType;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class Scythe
extends Weapon {
    public static Texture attackFrameTex;
    public static VAO attackVAO;

    public Scythe(Player p) {
        super(p);
        this.type = WeaponType.scythe;
    }

    @Override
    public void renderAttack(Matrix4f matrix) {
        Shaders.attackShader.enable();
        float frameProgress = 1.0f - ((float)this.attackFrame - 3.0f) / 13.0f;
        Shaders.attackShader.setUniform(0, 0, matrix.rotateZ(this.attackAngle - (float)(Math.PI * (double)frameProgress)));
        if (this.burning) {
            Shaders.attackShader.setUniform(2, 0, 1.0f, 0.6f, 0.22f);
        } else if (this.bloodied) {
            Shaders.attackShader.setUniform(2, 0, 1.0f, 0.6f, 0.22f);
        } else {
            Shaders.attackShader.setUniform(2, 0, 0.8f, 0.0f, 0.0f);
        }
        attackFrameTex.bind();
        attackVAO.fullRender();
    }

    @Override
    public void renderIdle(Matrix4f mat) {
        if (this.attackFrame > 3) {
            float frameProgress = 1.0f - ((float)this.attackFrame - 3.0f) / 13.0f;
            Shaders.textureShader.setUniform(0, 0, mat.rotateZ((float)(-Math.PI) * frameProgress).scale(0.5f).translate(0.0f, 5.0f, 0.0f));
        } else {
            float frameProgress = ((float)this.attackFrame - 3.0f) / 13.0f + 1.0f;
            Shaders.textureShader.setUniform(0, 0, mat.rotateZ((float)(-Math.PI) * frameProgress).scale(0.5f).translate(0.0f, 10.0f, 0.0f).rotateZ(1.5707964f));
        }
        this.bindTexture();
        Main.entityObj.drawTriangles();
    }

    @Override
    public boolean attackHits(Vector2f position, Vector2f player) {
        float frameProgress;
        float angleDiff;
        float distance = position.distance(player);
        return distance < 15.0f && (double)(angleDiff = EnigUtils.compareAngles(this.attackAngle - (float)(-1.5707963267948966 + Math.PI * (double)(frameProgress = 1.0f - ((float)this.attackFrame - 3.0f) / 13.0f)), (float)org.joml.Math.atan2(position.y - player.y, position.x - player.x))) < 0.3141592653589793;
    }

    @Override
    public float maxDurability() {
        return 30.0f;
    }

    public static void loadFrames() {
        attackFrameTex = new Texture("res/textures/weaponAnims/scythe/0.png");
        attackVAO = new VAO(-5.0f, -15.0f, 20.0f, 30.0f);
    }
}

