/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.EnigWindow;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Player;
import game.Shaders;
import game.WeaponType;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public abstract class Weapon
extends Vector2f {
    public static Texture swordTexture;
    public static Texture shieldTexture;
    public static Texture scytheTexture;
    public static Texture spearTexture;
    public static Texture styreneMonomerTexture;
    public static Texture flamingSwordTexture;
    public static Texture flamingShieldTexture;
    public static Texture flamingScytheTexture;
    public static Texture flamingSpearTexture;
    public static VAO weapOBJ;
    public int attackFrame = -10;
    public float attackAngle = 0.0f;
    public float durability;
    public boolean burning;
    public boolean bloodied;
    public WeaponType type;

    public Weapon(Player p) {
        double angle = Math.random() * Math.PI * 2.0;
        float distance = (float)(Math.sqrt(p.torchStrength) + Math.random() * 10.0) + 5.0f;
        this.x = (float)Math.cos(angle) * distance + p.x;
        this.y = (float)Math.sin(angle) * distance + p.y;
        this.durability = this.maxDurability();
    }

    public boolean startAttack(EnigWindow w, Player player, Vector2f camPos) {
        if (this.attackFrame <= -10) {
            if (this.durability == 0.0f) {
                return false;
            }
            if (this.burning) {
                this.durability -= 1.0f;
            }
            this.durability -= 1.0f;
            this.attackAngle = player.facingAngle(w, camPos);
            this.attackFrame = 16;
        }
        return true;
    }

    public abstract void renderAttack(Matrix4f var1);

    public abstract void renderIdle(Matrix4f var1);

    public abstract boolean attackHits(Vector2f var1, Vector2f var2);

    public abstract float maxDurability();

    public static void loadTextures() {
        swordTexture = new Texture("res/textures/weapons/sword.png");
        shieldTexture = new Texture("res/textures/weapons/shield.png");
        scytheTexture = new Texture("res/textures/weapons/scythe.png");
        spearTexture = new Texture("res/textures/weapons/spear.png");
        styreneMonomerTexture = new Texture("res/textures/weapons/styrene.png");
        flamingSwordTexture = new Texture("res/textures/weapons/flamingSword.png");
        flamingShieldTexture = new Texture("res/textures/weapons/flamingShield.png");
        flamingScytheTexture = new Texture("res/textures/weapons/flamingScythe.png");
        flamingSpearTexture = new Texture("res/textures/weapons/flamingSpear.png");
        weapOBJ = new VAO(-2.0f, -2.0f, 4.0f, 4.0f);
    }

    public static void renderWeapons(ArrayList<Weapon> weapons, Matrix4f perspectiveArray) {
        Shaders.textureShader.enable();
        weapOBJ.prepareRender();
        for (Weapon w : weapons) {
            w.bindTexture();
            Shaders.textureShader.setUniform(0, 0, perspectiveArray.translate(w.x, w.y, 0.0f, new Matrix4f()));
            weapOBJ.drawTriangles();
        }
        weapOBJ.unbind();
    }

    public void bindTexture() {
        if (this.type == WeaponType.sword) {
            if (this.burning) {
                flamingSwordTexture.bind();
            } else {
                swordTexture.bind();
            }
        } else if (this.type == WeaponType.spear) {
            if (this.burning) {
                flamingSpearTexture.bind();
            } else {
                spearTexture.bind();
            }
        } else if (this.type == WeaponType.shield) {
            if (this.burning) {
                flamingShieldTexture.bind();
            } else {
                shieldTexture.bind();
            }
        } else if (this.type == WeaponType.scythe) {
            if (this.burning) {
                flamingScytheTexture.bind();
            } else {
                scytheTexture.bind();
            }
        } else if (this.type == WeaponType.styreneMonomer) {
            styreneMonomerTexture.bind();
        }
    }
}

