/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.EnigWindow;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Enemy;
import game.Main;
import game.MainView;
import game.ParticleRenderer;
import game.Shaders;
import game.UserControls;
import game.Weapon;
import game.WeaponType;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class Player
extends Vector2f {
    public static Texture playerTexture;
    public static VAO weapUIObj;
    public static ParticleRenderer particles;
    public float torchStrength = 1000.0f;
    public ArrayList<Weapon> weapons = new ArrayList();
    public int selectedWeaponIndex;

    public void update(EnigWindow w, Vector2f camPos) {
        float mlength;
        Vector2f movement = new Vector2f();
        if (UserControls.up(w)) {
            movement.y += 1.0f;
        }
        if (UserControls.down(w)) {
            movement.y -= 1.0f;
        }
        if (UserControls.left(w)) {
            movement.x -= 1.0f;
        }
        if (UserControls.right(w)) {
            movement.x += 1.0f;
        }
        if ((double)(mlength = movement.length()) > 0.01) {
            movement.mul(0.15f / movement.length());
            if (Main.gameOverOpacity > 0.0f) {
                movement.mul(this.torchStrength * this.torchStrength / (Main.gameOverOpacity * Main.gameOverOpacity));
            }
            this.add(movement);
        }
        if (w.mouseButtons[1] == 1 && Main.gameOverOpacity < 0.0f) {
            this.weapons.get((int)this.selectedWeaponIndex).burning = true;
            if (MainView.main.tutorialFrame == 0) {
                MainView.main.tutorialFrame = 1;
                Enemy e = new Enemy(this);
                e.x = 0.0f;
                e.y = 50.0f;
                MainView.main.enemies.add(e);
            }
        }
        if (this.weapons.size() > 0 && this.weapons.get((int)this.selectedWeaponIndex).type == WeaponType.styreneMonomer) {
            this.weapons.get((int)this.selectedWeaponIndex).attackFrame = -10;
        }
        if (Main.gameOverOpacity < 0.0f && w.mouseButtons[0] > 1 && this.weapons.size() > 0 && this.selectedWeaponIndex < this.weapons.size()) {
            if (this.weapons.get((int)this.selectedWeaponIndex).type == WeaponType.styreneMonomer) {
                this.weapons.get((int)this.selectedWeaponIndex).durability -= 0.05f;
                this.weapons.get((int)this.selectedWeaponIndex).attackFrame = 10;
                float targetX = w.cursorXFloat * 50.0f * w.getAspectRatio() + camPos.x - this.x;
                float targetY = w.cursorYFloat * 50.0f + camPos.y - this.y;
                Vector2f target = new Vector2f(targetX, targetY);
                target.normalize(0.4f);
                this.add(target);
                if (this.weapons.get((int)this.selectedWeaponIndex).durability < 0.0f) {
                    MainView.main.sfxSource.setPitch(0.3f + (float)Math.random() / 5.0f);
                    MainView.main.sfxSource.playSound(MainView.main.breakingSounds[(int)(Math.random() * 2.0)]);
                    w.mouseButtons[0] = 0;
                    this.weapons.remove(this.selectedWeaponIndex);
                    if (this.weapons.size() == this.selectedWeaponIndex) {
                        --this.selectedWeaponIndex;
                        if (this.selectedWeaponIndex == -1) {
                            this.selectedWeaponIndex = 0;
                        }
                    }
                }
            } else if (!this.weapons.get(this.selectedWeaponIndex).startAttack(w, this, camPos)) {
                MainView.main.sfxSource.setPitch(0.3f + (float)Math.random() / 5.0f);
                MainView.main.sfxSource.playSound(MainView.main.breakingSounds[(int)(Math.random() * 2.0)]);
                w.mouseButtons[0] = 0;
                this.weapons.remove(this.selectedWeaponIndex);
                if (this.weapons.size() == this.selectedWeaponIndex) {
                    --this.selectedWeaponIndex;
                    if (this.selectedWeaponIndex == -1) {
                        this.selectedWeaponIndex = 0;
                    }
                }
            }
        }
        this.torchStrength = 0.0f;
        for (int i = 0; i < this.weapons.size(); ++i) {
            Weapon weap = this.weapons.get(i);
            if (!weap.burning) continue;
            weap.durability -= 0.005f;
            if (Main.gameOverOpacity > 0.0f) {
                weap.durability = (float)((double)weap.durability - 0.01);
                weap.durability *= 0.999f;
            }
            if (weap.durability <= 0.0f) {
                this.weapons.remove(i);
                if (i < this.selectedWeaponIndex) {
                    --this.selectedWeaponIndex;
                }
                --i;
                if (this.weapons.size() <= 0 || this.selectedWeaponIndex < this.weapons.size()) continue;
                --this.selectedWeaponIndex;
                continue;
            }
            this.torchStrength += weap.durability * 100.0f;
            if (weap.attackFrame <= 0) continue;
            this.torchStrength += (float)weap.attackFrame * 25.0f;
        }
        if (this.torchStrength < 1.0f) {
            this.torchStrength = 0.001f;
        }
    }

    public float facingAngle(EnigWindow w, Vector2f camPos) {
        float worldX = w.cursorXFloat * 50.0f * w.getAspectRatio();
        float worldY = w.cursorYFloat * 50.0f;
        return (float)Math.atan2(worldY - this.y + camPos.y, worldX - this.x + camPos.x);
    }

    public void renderPlayer(Matrix4f perspectiveMatrix, EnigWindow w, Vector2f camPos) {
        Shaders.textureShader.enable();
        Main.entityObj.prepareRender();
        if (this.weapons.size() > 0) {
            Weapon weap = this.weapons.get(this.selectedWeaponIndex);
            if ((float)weap.attackFrame > -9.0f) {
                weap.renderIdle(new Matrix4f(perspectiveMatrix).rotateZ(weap.attackAngle));
            } else {
                weap.renderIdle(new Matrix4f(perspectiveMatrix).rotateZ(this.facingAngle(w, camPos)));
            }
        }
        Main.entityObj.unbind();
        if (this.weapons.size() > 0) {
            Weapon selectedWeapon = this.weapons.get(this.selectedWeaponIndex);
            if (selectedWeapon.attackFrame > 3) {
                selectedWeapon.renderAttack(new Matrix4f(perspectiveMatrix));
            }
            --selectedWeapon.attackFrame;
            if (selectedWeapon.attackFrame < -10) {
                selectedWeapon.attackFrame = -10;
            }
        }
        if (Player.particles.color.x < 0.999f) {
            Player.particles.color.x += 0.01f;
            Player.particles.color.y += 0.002f;
            Player.particles.color.z -= 0.01f;
        }
        particles.updateAndRender(perspectiveMatrix);
    }

    public boolean shouldKill(Vector2f enemy) {
        if (this.weapons.size() > 0) {
            Weapon selectedWeapon = this.weapons.get(this.selectedWeaponIndex);
            if (selectedWeapon.attackFrame > 3) {
                return selectedWeapon.attackHits(enemy, this);
            }
        }
        return false;
    }

    public void renderWeaponUI(EnigWindow w, Matrix4f mat) {
        Weapon weap;
        Shaders.weapUIShader.enable();
        weapUIObj.prepareRender();
        for (int i = 0; i < this.weapons.size(); ++i) {
            if (i == this.selectedWeaponIndex) continue;
            weap = this.weapons.get(i);
            float yoffset = 6 * (this.selectedWeaponIndex - i);
            yoffset = i < this.selectedWeaponIndex ? (yoffset += 5.0f) : (yoffset -= 5.0f);
            Shaders.weapUIShader.setUniform(0, 0, mat.translate(w.getAspectRatio() * 50.0f - 2.0f, yoffset, 0.0f, new Matrix4f()).scale(0.5f));
            Shaders.weapUIShader.setUniform(2, 0, weap.durability / weap.maxDurability());
            weap.bindTexture();
            weapUIObj.drawTriangles();
        }
        weap = this.weapons.get(this.selectedWeaponIndex);
        Shaders.weapUIShader.setUniform(0, 0, mat.translate(w.getAspectRatio() * 50.0f - 5.0f, 0.0f, 0.0f, new Matrix4f()));
        Shaders.weapUIShader.setUniform(2, 0, weap.durability / weap.maxDurability());
        weap.bindTexture();
        weapUIObj.drawTriangles();
        weapUIObj.unbind();
    }
}

