/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.EnigWindow;
import game.Main;
import game.Shaders;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ParticleRenderer {
    public Vector3f[] particles;
    public Vector3f[] colorOffsets;
    public Vector3f color;
    public boolean sustained = true;
    public Vector3f colorOffsetCoeff = new Vector3f(0.25f, 0.25f, 0.25f);

    public ParticleRenderer(float r, float g, float b, int particleCount) {
        this.color = new Vector3f(r, g, b);
        this.particles = new Vector3f[particleCount];
        this.colorOffsets = new Vector3f[particleCount];
        for (int i = 0; i < particleCount; ++i) {
            this.particles[i] = new Vector3f();
            double angle = Math.random() * Math.PI * 2.0;
            float distance = (float)Math.random() + 0.1f;
            this.particles[i].x = (float)Math.cos(angle) * distance;
            this.particles[i].y = (float)Math.sin(angle) * distance;
            this.particles[i].z = (float)Math.random();
            this.colorOffsets[i] = new Vector3f();
            this.colorOffsets[i].x = (float)Math.random();
            this.colorOffsets[i].y = (float)Math.random();
            this.colorOffsets[i].z = (float)Math.random();
        }
    }

    public void updateAndRender(Matrix4f mat) {
        Shaders.particleShader.enable();
        Main.screenObj.prepareRender();
        for (int i = 0; i < this.particles.length; ++i) {
            Shaders.particleShader.setUniform(2, 0, this.color.x + this.colorOffsets[i].x * this.colorOffsetCoeff.x, this.color.y + this.colorOffsets[i].y * this.colorOffsetCoeff.y, this.color.z + this.colorOffsets[i].z * this.colorOffsetCoeff.z);
            Shaders.particleShader.setUniform(0, 0, new Matrix4f(mat).translate(this.particles[i].x, this.particles[i].y, 0.0f));
            Shaders.particleShader.setUniform(2, 1, this.particles[i].z);
            Main.screenObj.drawTriangles();
            this.particles[i].x *= 1.02f;
            this.particles[i].y *= 1.02f;
            this.particles[i].z -= 0.01f;
            if (!(this.particles[i].z < 0.0f)) continue;
            if (this.sustained) {
                double angle = Math.random() * Math.PI * 2.0;
                float distance = (float)Math.random() + 0.1f;
                this.particles[i].x = (float)Math.cos(angle) * distance;
                this.particles[i].y = (float)Math.sin(angle) * distance;
                this.particles[i].z = (float)Math.random();
                continue;
            }
            this.particles[i].z = 0.0f;
        }
        Main.screenObj.unbind();
        EnigWindow.checkGLError();
    }
}

