/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.EnigWindow;
import engine.OpenGL.ShaderProgram;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import org.joml.Matrix4f;

public class NumberRenderer {
    public static Texture[] textures = new Texture[10];
    public static VAO shape;
    public static ShaderProgram shader;
    public Matrix4f mat;
    public float fontSize;
    public float x;
    public float y;
    public boolean centered = true;

    public NumberRenderer(int width, int height, int fontSize, float x, float y) {
        if (shape == null) {
            for (int i = 0; i < 10; ++i) {
                NumberRenderer.textures[i] = new Texture("res/textures/numbers/" + i + ".png");
            }
            shape = new VAO(-0.5f, -1.0f, 1.0f, 2.0f);
            shader = new ShaderProgram("numberShader");
        }
        this.mat = new Matrix4f().ortho(-width / 2, width / 2, -height / 2, height / 2, 0.0f, 1.0f);
        this.fontSize = 1080.0f * (float)fontSize / (float)EnigWindow.mainWindow.getHeight();
        this.x = x;
        this.y = y;
    }

    public void renderNum(int num) {
        shader.enable();
        String str = "" + num;
        shape.prepareRender();
        float offset = this.x;
        for (int i = 0; i < str.length(); ++i) {
            textures[Character.getNumericValue(str.charAt(i))].bind();
            Matrix4f temp = new Matrix4f(this.mat);
            NumberRenderer.shader.shaders[0].uniforms[0].set(temp.translate(offset + (float)i * 0.8f * this.fontSize, this.y, 0.0f).scale(this.fontSize));
            shape.drawTriangles();
        }
        shape.unbind();
    }
}

