/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.EnigView;
import engine.OpenGL.EnigWindow;
import engine.OpenGL.FBO;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Main;
import game.MainView;
import game.Shaders;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class MenuView
extends EnigView {
    public static MenuView main;
    public Texture titleTexture;
    public Texture tutorialButtonTexture;
    public Texture playButtonTexture;
    public Texture quitButtonTexture;
    public VAO tutorialButton;
    public VAO playButton;
    public VAO quitButton;

    public MenuView(EnigWindow window) {
        super(window);
        GL11.glDisable(2929);
        this.titleTexture = new Texture("res/textures/titleText.png");
        this.tutorialButtonTexture = new Texture("res/textures/tutorial.png");
        this.playButtonTexture = new Texture("res/textures/play.png");
        this.quitButtonTexture = new Texture("res/textures/quit.png");
        this.playButton = new VAO(-window.getAspectRatio() * 50.0f + 10.0f, -10.0f, 16.0f, 8.0f);
        this.tutorialButton = new VAO(-window.getAspectRatio() * 50.0f + 10.0f, -20.0f, 16.0f, 8.0f);
        this.quitButton = new VAO(-window.getAspectRatio() * 50.0f + 10.0f, -30.0f, 16.0f, 8.0f);
    }

    @Override
    public boolean loop() {
        FBO.prepareDefaultRender();
        FBO.clearCurrentFrameBuffer();
        Shaders.titleShader.enable();
        Shaders.titleShader.setUniform(0, 0, this.getPerspectiveMatrix());
        Shaders.titleShader.setUniform(2, 0, this.window.cursorXFloat * 50.0f * this.window.getAspectRatio(), this.window.cursorYFloat * 50.0f);
        Shaders.titleShader.setUniform(2, 1, 1.0f);
        this.titleTexture.bind();
        Main.titleObj.fullRender();
        Shaders.buttonShader.enable();
        Shaders.buttonShader.setUniform(0, 0, this.getPerspectiveMatrix());
        Shaders.buttonShader.setUniform(2, 0, this.window.cursorXFloat * 50.0f * this.window.getAspectRatio(), this.window.cursorYFloat * 50.0f);
        Shaders.buttonShader.setUniform(2, 1, 1.0f);
        Shaders.buttonShader.setUniform(2, 2, 0.0f);
        float rat = this.window.getAspectRatio() * 50.0f;
        if (this.window.cursorXFloat + 1.0f > 10.0f / rat && this.window.cursorXFloat + 1.0f < 26.0f / rat && this.window.cursorYFloat * 50.0f > -10.0f && this.window.cursorYFloat * 50.0f < -2.0f) {
            if (this.window.mouseButtons[0] > 1) {
                MainView.main.tutorialFrame = -1;
                MainView.main.runLoop();
                return false;
            }
            Shaders.buttonShader.setUniform(2, 2, 1.0f);
        }
        this.playButtonTexture.bind();
        this.playButton.fullRender();
        Shaders.buttonShader.setUniform(2, 2, 0.0f);
        if (this.window.cursorXFloat + 1.0f > 10.0f / rat && this.window.cursorXFloat + 1.0f < 26.0f / rat && this.window.cursorYFloat * 50.0f > -20.0f && this.window.cursorYFloat * 50.0f < -12.0f) {
            if (this.window.mouseButtons[0] > 1) {
                this.window.mouseButtons[0] = 0;
                MainView.main.tutorialFrame = 0;
                MainView.main.player.weapons.get((int)0).burning = false;
                MainView.main.runLoop();
                return false;
            }
            Shaders.buttonShader.setUniform(2, 2, 1.0f);
        }
        this.tutorialButtonTexture.bind();
        this.tutorialButton.fullRender();
        Shaders.buttonShader.setUniform(2, 2, 0.0f);
        if (this.window.cursorXFloat + 1.0f > 10.0f / rat && this.window.cursorXFloat + 1.0f < 26.0f / rat && this.window.cursorYFloat * 50.0f > -30.0f && this.window.cursorYFloat * 50.0f < -22.0f) {
            if (this.window.mouseButtons[0] > 1) {
                return true;
            }
            Shaders.buttonShader.setUniform(2, 2, 1.0f);
        }
        this.quitButtonTexture.bind();
        this.quitButton.fullRender();
        return false;
    }

    public Matrix4f getPerspectiveMatrix() {
        return new Matrix4f(MainView.main.perspectiveMatrix);
    }
}

