/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.EnigView;
import engine.OpenAL.Sound;
import engine.OpenAL.SoundSource;
import engine.OpenGL.EnigWindow;
import engine.OpenGL.FBO;
import engine.OpenGL.Texture;
import engine.OpenGL.VAO;
import game.Enemy;
import game.Main;
import game.NumberRenderer;
import game.ParticleRenderer;
import game.Player;
import game.Shaders;
import game.UserControls;
import game.Weapon;
import game.weapons.Scythe;
import game.weapons.Shield;
import game.weapons.Spear;
import game.weapons.StyreneMonomer;
import game.weapons.Sword;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.lwjgl.opengl.GL11;

public class MainView
extends EnigView {
    public static MainView main;
    public Matrix4f perspectiveMatrix;
    public Vector2f camPos = new Vector2f();
    public Player player = new Player();
    public ArrayList<Weapon> weapons = new ArrayList();
    public ArrayList<Enemy> enemies = new ArrayList();
    public ArrayList<Enemy> dyingEnemies = new ArrayList();
    public Texture tile;
    public Texture gameoverTexture;
    public Texture[] tutorialFrames;
    public SoundSource sfxSource;
    public SoundSource[] deathSources;
    public Sound[] breakingSounds;
    public Sound[] deathSounds;
    public NumberRenderer scoreRenderer;
    int score = 0;
    public int deathIndex = 0;
    public int tutorialFrame = -1;

    public MainView(EnigWindow window) {
        super(window);
        int i;
        GL11.glDisable(2929);
        this.perspectiveMatrix = window.getSquarePerspectiveMatrix(100.0f);
        Weapon.loadTextures();
        Sword.loadFrames();
        Scythe.loadFrames();
        Spear.loadFrames();
        Shield.loadFrames();
        this.tile = new Texture("res/textures/tile2.png");
        this.gameoverTexture = new Texture("res/textures/gameOverText.png");
        Player.playerTexture = new Texture("res/textures/player0.png");
        Enemy.enemyTexture = new Texture("res/textures/ghost.png");
        this.tutorialFrames = new Texture[4];
        for (i = 0; i < 4; ++i) {
            this.tutorialFrames[i] = new Texture("res/textures/tutorialFrames/" + i + ".png");
        }
        Player.particles = new ParticleRenderer(1.0f, 0.2f, 0.0f, 50);
        Player.weapUIObj = new VAO(-5.0f, -5.0f, 10.0f, 10.0f, 1.0f);
        this.player.weapons.add(new Scythe(this.player));
        if (this.tutorialFrame == -1) {
            this.player.weapons.get((int)0).burning = true;
        }
        this.sfxSource = new SoundSource();
        this.breakingSounds = new Sound[2];
        for (i = 0; i < this.breakingSounds.length; ++i) {
            this.breakingSounds[i] = new Sound("res/sounds/breaking/" + i + ".wav");
        }
        this.deathSources = new SoundSource[10];
        for (i = 0; i < this.deathSources.length; ++i) {
            this.deathSources[i] = new SoundSource();
        }
        this.deathSounds = new Sound[5];
        for (i = 0; i < this.deathSounds.length; ++i) {
            this.deathSounds[i] = new Sound("res/sounds/dying/" + i + ".wav");
        }
        this.scoreRenderer = new NumberRenderer(window.getWidth(), window.getHeight(), 50, -window.getWidth() / 2 + 25, -window.getHeight() / 2 + 50);
    }

    @Override
    public boolean loop() {
        FBO.prepareDefaultRender();
        FBO.clearCurrentFrameBuffer();
        if (UserControls.restart(this.window)) {
            this.restart();
        }
        if (this.tutorialFrame == -1) {
            this.generateEnemies();
        }
        if (this.tutorialFrame != 0) {
            this.manageSpawns();
        }
        this.renderScene();
        this.scoreRenderer.renderNum(this.score);
        this.updateCamera();
        if (this.tutorialFrame >= 0) {
            Shaders.textureShader.enable();
            Shaders.textureShader.setUniform(0, 0, this.getUnTranslatedPerspectiveMatrix());
            this.tutorialFrames[this.tutorialFrame].bind();
            Main.titleObj.fullRender();
        }
        if (UserControls.quit(this.window)) {
            this.restart();
            return true;
        }
        return false;
    }

    public void renderScene() {
        this.renderBackground();
        Weapon.renderWeapons(this.weapons, this.getPerspectiveMatrix());
        this.player.renderPlayer(this.getPerspectiveMatrix().translate(this.player.x, this.player.y, 0.0f), this.window, this.camPos);
        this.renderEnemies();
        this.renderWall();
        this.renderUI();
        if (Main.gameOverOpacity > 0.0f) {
            float f = this.player.torchStrength / Main.gameOverOpacity;
        }
    }

    public void updateCamera() {
        this.player.update(this.window, this.camPos);
        float camFollowDist = 15.0f;
        if (this.player.x - this.camPos.x > 15.0f) {
            this.camPos.x = this.player.x - 15.0f;
        } else if (this.camPos.x - this.player.x > 15.0f) {
            this.camPos.x = this.player.x + 15.0f;
        }
        if (this.player.y - this.camPos.y > 15.0f) {
            this.camPos.y = this.player.y - 15.0f;
        } else if (this.camPos.y - this.player.y > 15.0f) {
            this.camPos.y = this.player.y + 15.0f;
        }
    }

    public void manageSpawns() {
        if (Main.gameOverOpacity < 0.0f) {
            double rand = Math.random();
            if (Math.random() < (double)(1.0f / (float)this.weapons.size()) || this.weapons.size() == 0) {
                if (rand > 0.999) {
                    this.weapons.add(new Scythe(this.player));
                } else if (rand > 0.995) {
                    this.weapons.add(new Shield(this.player));
                } else if (rand > 0.992) {
                    this.weapons.add(new Sword(this.player));
                } else if (rand > 0.98) {
                    this.weapons.add(new Spear(this.player));
                } else if (rand > 0.979) {
                    this.weapons.add(new StyreneMonomer(this.player));
                }
            }
            for (int i = 0; i < this.weapons.size(); ++i) {
                Weapon w = this.weapons.get(i);
                float dist = w.distanceSquared(this.player);
                if (dist > this.player.torchStrength * 2.0f + 20.0f) {
                    this.weapons.remove(i);
                    --i;
                    continue;
                }
                if (!(dist < 25.0f)) continue;
                this.player.weapons.add(w);
                this.weapons.remove(i);
                --i;
                if (this.tutorialFrame != 2) continue;
                this.tutorialFrame = 3;
            }
        }
    }

    public void generateEnemies() {
        if (Main.gameOverOpacity > 0.0f) {
            if (Math.random() > 0.02) {
                this.enemies.add(new Enemy(this.player));
            }
            while (this.enemies.size() > 1000) {
                this.enemies.remove(0);
            }
        } else {
            if (Math.random() < 0.02) {
                this.enemies.add(new Enemy(this.player));
            }
            if (Math.random() < (double)(1.0E-4f * (float)this.enemies.size())) {
                int k = 0;
                while (this.enemies.get((int)k).eliteTimer > -1.0f) {
                    if (k >= this.enemies.size()) {
                        return;
                    }
                    ++k;
                }
                this.enemies.get((int)k).eliteTimer = -1.0f;
            }
        }
    }

    public void renderWeaponUI() {
        if (this.player.weapons.size() > 0 && Main.gameOverOpacity < 0.0f) {
            this.player.renderWeaponUI(this.window, this.getUnTranslatedPerspectiveMatrix());
        }
    }

    public void renderUI() {
        this.renderWeaponUI();
        if (Main.gameOverOpacity > 0.0f) {
            Shaders.titleShader.enable();
            Shaders.titleShader.setUniform(0, 0, this.getUnTranslatedPerspectiveMatrix());
            Shaders.titleShader.setUniform(2, 0, this.player.x - this.camPos.x, this.player.y - this.camPos.y);
            Shaders.titleShader.setUniform(2, 1, 1.0f - this.player.torchStrength / Main.gameOverOpacity);
            this.gameoverTexture.bind();
            Main.titleObj.fullRender();
        }
    }

    public void renderEnemies() {
        float enemyAngle;
        Enemy e;
        int i;
        Shaders.textureShader.enable();
        Main.entityObj.prepareRender();
        Enemy.enemyTexture.bind();
        for (i = 0; i < this.enemies.size(); ++i) {
            e = this.enemies.get(i);
            float distsqrd = this.player.distanceSquared(e);
            if (Main.gameOverOpacity < 0.0f) {
                if (distsqrd < 36.0f) {
                    Main.gameOverOpacity = this.player.torchStrength;
                    if (Main.gameOverOpacity < 1.0f) {
                        Main.gameOverOpacity = 1.0f;
                    }
                    for (int j = 0; j < this.player.weapons.size(); ++j) {
                        if (this.player.weapons.get((int)j).burning) continue;
                        this.player.weapons.remove(j);
                        --j;
                    }
                    this.player.selectedWeaponIndex = 0;
                }
                if (this.player.shouldKill(e)) {
                    ++this.score;
                    this.deathSources[this.deathIndex].setPitch(0.5f + (float)Math.random() / 3.0f);
                    this.deathSources[this.deathIndex].playSound(this.deathSounds[(int)(Math.random() * 5.0)]);
                    ++this.deathIndex;
                    if (this.deathIndex >= this.deathSources.length) {
                        this.deathIndex = 0;
                    }
                    this.dyingEnemies.add(e);
                    e.eliteTimer = 0.0f;
                    e.particles.sustained = false;
                    this.enemies.remove(i);
                    --i;
                    if (this.tutorialFrame != 1) continue;
                    this.tutorialFrame = 2;
                    continue;
                }
            }
            float enemyAngle2 = e.facingAngle(this.player);
            Shaders.textureShader.setUniform(0, 0, this.getPerspectiveMatrix().translate(e.x, e.y, 0.0f).rotateZ(enemyAngle2));
            if (distsqrd > 10.0f) {
                e.update(enemyAngle2);
            }
            Main.entityObj.drawTriangles();
        }
        if (Main.gameOverOpacity < 0.0f) {
            Main.entityObj.unbind();
            for (i = 0; i < this.enemies.size(); ++i) {
                e = this.enemies.get(i);
                if (!(e.eliteTimer > -2.0f)) continue;
                enemyAngle = e.facingAngle(this.player);
                e.particles.updateAndRender(this.getPerspectiveMatrix().translate(e.x, e.y, 0.0f).rotateZ(enemyAngle));
            }
        }
        for (i = 0; i < this.dyingEnemies.size(); ++i) {
            e = this.dyingEnemies.get(i);
            enemyAngle = e.facingAngle(this.player);
            e.particles.updateAndRender(this.getPerspectiveMatrix().translate(e.x, e.y, 0.0f));
            e.eliteTimer = (float)((double)e.eliteTimer + 0.01);
            if (!(e.eliteTimer > 1.0f)) continue;
            this.dyingEnemies.remove(i);
            --i;
        }
    }

    public void renderBackground() {
        Shaders.tileShader.enable();
        Shaders.tileShader.setUniform(0, 0, this.window.getAspectRatio());
        Shaders.tileShader.setUniform(0, 1, this.camPos);
        this.tile.bind();
        Main.screenObj.fullRender();
    }

    public void renderWall() {
        Shaders.wallShader.enable();
        Shaders.wallShader.setUniform(0, 0, this.window.getAspectRatio());
        Shaders.wallShader.setUniform(0, 1, this.camPos);
        Shaders.wallShader.setUniform(2, 0, this.player);
        Shaders.wallShader.setUniform(2, 1, this.player.torchStrength);
        Main.screenObj.fullRender();
    }

    public void restart() {
        while (this.player.weapons.size() > 0) {
            this.player.weapons.remove(0);
        }
        while (this.weapons.size() > 0) {
            this.weapons.remove(0);
        }
        while (this.enemies.size() > 0) {
            this.enemies.remove(0);
        }
        this.camPos.x = 0.0f;
        this.camPos.y = 0.0f;
        Main.gameOverOpacity = -1.0f;
        this.player.x = 0.0f;
        this.player.y = 0.0f;
        this.player.weapons.add(new Scythe(this.player));
        this.player.weapons.get((int)0).burning = true;
        this.score = 0;
    }

    public Matrix4f getPerspectiveMatrix() {
        return new Matrix4f(this.perspectiveMatrix).translate(-this.camPos.x, -this.camPos.y, 0.0f);
    }

    public Matrix4f getUnTranslatedPerspectiveMatrix() {
        return new Matrix4f(this.perspectiveMatrix);
    }
}

