/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenAL.SoundSource;
import engine.OpenGL.EnigWindow;
import engine.OpenGL.VAO;
import game.AudioHandler;
import game.MainView;
import game.MenuView;
import game.Shaders;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Main {
    public static VAO screenObj;
    public static VAO entityObj;
    public static VAO titleObj;
    public static float gameOverOpacity;
    public static SoundSource source;

    public static void main(String[] args) {
        if (args.length == 0) {
            String os = System.getProperty("os.name");
            System.out.println("Operating System: " + os);
            if (os.indexOf("mac") >= 0 || os.indexOf("Mac") >= 0) {
                try {
                    Process proc = Runtime.getRuntime().exec(new String[]{"java", "-jar", "-XstartOnFirstThread", "FlamingResistance.jar", "noReRun"});
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    proc.waitFor();
                    String s = null;
                    while ((s = stdInput.readLine()) != null) {
                        System.out.println(s);
                    }
                    while ((s = stdError.readLine()) != null) {
                        System.out.println(s);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                Main.runGame();
            }
        } else if (args[0].equals("noReRun")) {
            Main.runGame();
        }
    }

    public static void runGame() {
        EnigWindow.runOpeningSequence = false;
        EnigWindow window = new EnigWindow("Flaming Resistance", "res/textures/icon.png");
        source = new SoundSource();
        Shaders.createMainShaders();
        screenObj = new VAO(-1.0f, -1.0f, 2.0f, 2.0f);
        entityObj = new VAO(-5.0f, -5.0f, 10.0f, 10.0f);
        titleObj = new VAO(-30.0f, 10.0f, 60.0f, 30.0f);
        window.fps = 60;
        MainView.main = new MainView(window);
        MenuView.main = new MenuView(window);
        AudioHandler.setup();
        MenuView.main.runLoop();
        AudioHandler.timer.cancel();
        window.terminate();
    }

    static {
        gameOverOpacity = -1.0f;
    }
}

