/*
 * Decompiled with CFR 0.152.
 */
package game;

import engine.OpenGL.Texture;
import game.ParticleRenderer;
import game.Player;
import org.joml.Vector2f;

public class Enemy
extends Vector2f {
    public static Texture enemyTexture;
    public ParticleRenderer particles;
    public float eliteTimer = -2.0f;
    public int hp;

    public Enemy(Player p) {
        double angle = Math.random() * Math.PI * 2.0;
        float distance = (float)(Math.sqrt(p.torchStrength) + Math.random() * 10.0) + 5.0f;
        this.x = (float)Math.cos(angle) * distance + p.x;
        this.y = (float)Math.sin(angle) * distance + p.y;
        this.particles = new ParticleRenderer(0.0f, 0.0f, 0.0f, 25);
        this.particles.colorOffsetCoeff.x = 0.0f;
        this.particles.colorOffsetCoeff.y = 0.0f;
        this.particles.colorOffsetCoeff.z = 0.0f;
    }

    public void update(float angle) {
        if (this.eliteTimer > 0.0f) {
            this.x = (float)((double)this.x + Math.cos(angle) * ((double)0.1f + (double)this.eliteTimer * 0.1 * (double)this.eliteTimer));
            this.y = (float)((double)this.y + Math.sin(angle) * ((double)0.1f + (double)this.eliteTimer * 0.1 * (double)this.eliteTimer));
            this.particles.colorOffsetCoeff.x = 0.4f * this.eliteTimer;
            this.particles.colorOffsetCoeff.z = 0.8f * this.eliteTimer;
        } else {
            this.x = (float)((double)this.x + Math.cos(angle) * (double)0.1f);
            this.y = (float)((double)this.y + Math.sin(angle) * (double)0.1f);
        }
        if (this.eliteTimer > -2.0f && this.eliteTimer < 1.0f) {
            this.eliteTimer += 0.02f;
        }
    }

    public float facingAngle(Player p) {
        return (float)Math.atan2(p.y - this.y, p.x - this.x);
    }
}

