/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import org.joml.Vector2f;
import org.joml.Vector3f;

public class Simplex2v3d {
    private Vector3f pointA;
    private Vector3f pointB;
    private Vector3f pointC;
    private Vector3f normal;
    private Vector3f xProduct;

    public Simplex2v3d(Vector3f a, Vector3f b, Vector3f c) {
        Vector3f na = new Vector3f(a.x - c.x, a.y - c.y, a.z - c.z);
        Vector3f nb = new Vector3f(b.x - c.x, b.y - c.y, b.z - c.z);
        this.xProduct = na.cross(nb).normalize();
        this.normal = this.xProduct.normalize(new Vector3f());
        this.pointA = a;
        this.pointB = b;
        this.pointC = c;
    }

    public Simplex2v3d(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz) {
        Vector3f na = new Vector3f(ax - cx, ay - cy, az - cz);
        Vector3f nb = new Vector3f(bx - cx, by - cy, bz - cz);
        this.xProduct = na.cross(nb).normalize();
        this.normal = this.xProduct.normalize(new Vector3f());
        this.pointA = new Vector3f(ax, ay, az);
        this.pointB = new Vector3f(bx, by, bz);
        this.pointC = new Vector3f(cx, cy, cz);
    }

    public Simplex2v3d(Vector3f norm, Vector3f point) {
        this.xProduct = this.normal = norm;
        this.pointA = new Vector3f(-1.0f, (-norm.x + norm.z) / norm.y + point.y, 1.0f);
        this.pointB = new Vector3f(1.0f, (norm.x + norm.z) / norm.y + point.y, 1.0f);
        this.pointC = new Vector3f(-1.0f, (-norm.x - norm.z) / norm.y + point.y, -1.0f);
        Vector3f na = new Vector3f(this.pointA.x - this.pointC.x, this.pointA.y - this.pointC.y, this.pointA.z - this.pointC.z);
        Vector3f nb = new Vector3f(this.pointB.x - this.pointC.x, this.pointB.y - this.pointC.y, this.pointB.z - this.pointC.z);
        this.xProduct = na.cross(nb).normalize();
        this.normal = this.xProduct.normalize(new Vector3f());
    }

    public Simplex2v3d(float xCoeff, float zCoeff, Vector3f point) {
        this.pointA = new Vector3f(-1.0f + point.x, -xCoeff + zCoeff + point.y, 1.0f + point.z);
        this.pointB = new Vector3f(1.0f + point.x, xCoeff + zCoeff + point.y, 1.0f + point.z);
        this.pointC = new Vector3f(-1.0f + point.x, -xCoeff - zCoeff + point.y, -1.0f + point.z);
        Vector3f na = new Vector3f(this.pointA.x - this.pointC.x, this.pointA.y - this.pointC.y, this.pointA.z - this.pointC.z);
        Vector3f nb = new Vector3f(this.pointB.x - this.pointC.x, this.pointB.y - this.pointC.y, this.pointB.z - this.pointC.z);
        this.xProduct = na.cross(nb).normalize();
        this.normal = this.xProduct.normalize(new Vector3f());
    }

    public float getx(float y, float z) {
        return -(this.xProduct.y * (y - this.pointC.y) + this.xProduct.z * (z - this.pointC.z)) / this.xProduct.x + this.pointC.x;
    }

    public float getx(Vector2f v) {
        return this.getx(v.x, v.y);
    }

    public float gety(float x, float z) {
        return -(this.xProduct.x * (x - this.pointC.x) + this.xProduct.z * (z - this.pointC.z)) / this.xProduct.y + this.pointC.y;
    }

    public float gety(Vector2f v) {
        return this.gety(v.x, v.y);
    }

    public float getz(float x, float y) {
        return -(this.xProduct.x * (x - this.pointC.x) + this.xProduct.y * (y - this.pointC.y)) / this.xProduct.z + this.pointC.z;
    }

    public float getz(Vector2f v) {
        return this.getz(v.x, v.y);
    }
}

