/*
 * Decompiled with CFR 0.152.
 */
package engine.Platform;

import engine.Platform.Box2d;
import org.joml.Vector2f;

public class Simplex2v2d {
    private Vector2f pointA;
    private Vector2f pointB;
    private Vector2f pointC;
    float doubleAreaReciprocal;

    public Simplex2v2d(Vector2f a, Vector2f b, Vector2f c) {
        this.pointA = a;
        this.pointB = b;
        this.pointC = c;
        this.updateDoubleAreaReciprocal();
    }

    public Simplex2v2d(float ax, float ay, float bx, float by, float cx, float cy) {
        this.pointA = new Vector2f(ax, ay);
        this.pointB = new Vector2f(bx, by);
        this.pointC = new Vector2f(cx, cy);
        this.updateDoubleAreaReciprocal();
    }

    private void updateDoubleAreaReciprocal() {
        this.doubleAreaReciprocal = 1.0f / (this.pointA.x * this.pointB.y - this.pointA.x * this.pointC.y - this.pointB.x * this.pointA.y + this.pointB.x * this.pointC.y + this.pointC.x * this.pointA.y - this.pointC.x * this.pointB.y);
    }

    public boolean containsPoint(Vector2f other) {
        return this.containsPoint(other.x, other.y);
    }

    public boolean containsPoint(float ox, float oy) {
        float u = (ox * this.pointB.y - ox * this.pointC.y - this.pointB.x * oy + this.pointB.x * this.pointC.y + this.pointC.x * oy - this.pointC.x * this.pointB.y) * this.doubleAreaReciprocal;
        float v = (this.pointA.x * oy - this.pointA.x * this.pointC.y - ox * this.pointA.y + ox * this.pointC.y + this.pointC.x * this.pointA.y - this.pointC.x * oy) * this.doubleAreaReciprocal;
        if (u + v > 1.0f) {
            return false;
        }
        if (u < 0.0f) {
            return false;
        }
        return !(v < 0.0f);
    }

    public boolean containsPoint(float ox, float oy, float extra) {
        float u = (ox * this.pointB.y - ox * this.pointC.y - this.pointB.x * oy + this.pointB.x * this.pointC.y + this.pointC.x * oy - this.pointC.x * this.pointB.y) * this.doubleAreaReciprocal;
        if (u < -extra) {
            return false;
        }
        float v = (this.pointA.x * oy - this.pointA.x * this.pointC.y - ox * this.pointA.y + ox * this.pointC.y + this.pointC.x * this.pointA.y - this.pointC.x * oy) * this.doubleAreaReciprocal;
        if (u + v > 1.0f + extra) {
            return false;
        }
        return !(v < -extra);
    }

    public boolean touches(Box2d box) {
        if (box.contains(this.pointA)) {
            return true;
        }
        if (box.contains(this.pointB)) {
            return true;
        }
        if (box.contains(this.pointC)) {
            return true;
        }
        if (this.containsPoint(box.minx, box.miny)) {
            return true;
        }
        if (this.containsPoint(box.minx, box.maxy)) {
            return true;
        }
        if (this.containsPoint(box.maxx, box.miny)) {
            return true;
        }
        return this.containsPoint(box.maxx, box.maxy);
    }

    public boolean touches(Box2d box, float extra) {
        if (box.contains(this.pointA, extra)) {
            return true;
        }
        if (box.contains(this.pointB, extra)) {
            return true;
        }
        if (box.contains(this.pointC, extra)) {
            return true;
        }
        if (this.containsPoint(box.minx, box.miny, extra)) {
            return true;
        }
        if (this.containsPoint(box.minx, box.maxy, extra)) {
            return true;
        }
        if (this.containsPoint(box.maxx, box.miny, extra)) {
            return true;
        }
        return this.containsPoint(box.maxx, box.maxy);
    }

    public void setPointA(Vector2f pointA) {
        this.pointA = pointA;
        this.updateDoubleAreaReciprocal();
    }

    public void setPointB(Vector2f pointB) {
        this.pointB = pointB;
        this.updateDoubleAreaReciprocal();
    }

    public void setPointC(Vector2f pointC) {
        this.pointC = pointC;
        this.updateDoubleAreaReciprocal();
    }

    public Vector2f getPointA() {
        return new Vector2f(this.pointA);
    }

    public Vector2f getPointB() {
        return new Vector2f(this.pointB);
    }

    public Vector2f getPointC() {
        return new Vector2f(this.pointC);
    }
}

