/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.OpenGL.ShaderProgram;
import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class Uniform {
    private String name;
    private int vecSize;
    private int type;
    private static FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer(16);

    public Uniform(String uname, int size) {
        if (size > 4 || size < 1) {
            throw new RuntimeException("invalid vector size");
        }
        this.name = uname;
        this.vecSize = size;
        this.type = 0;
    }

    public Uniform(String uname, int size, int dt) {
        if (size > 4 || size < 1) {
            throw new RuntimeException("invalid vector size");
        }
        this.name = uname;
        this.vecSize = size;
        this.type = dt;
    }

    public String getName() {
        return this.name;
    }

    public void set(float[] info) {
        if (this.type == 2) {
            throw new RuntimeException("cannot set a matrix uniform with vector information");
        }
        if (this.type == 1) {
            throw new RuntimeException("cannot set an integer uniform with vector information");
        }
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        if (this.vecSize == 1) {
            GL20.glUniform1f(pos, info[0]);
        } else if (this.vecSize == 2) {
            GL20.glUniform2f(pos, info[0], info[1]);
        } else if (this.vecSize == 3) {
            GL20.glUniform3f(pos, info[0], info[1], info[2]);
        } else if (this.vecSize == 4) {
            GL20.glUniform4f(pos, info[0], info[1], info[2], info[3]);
        }
    }

    public void set(Matrix4f info) {
        if (this.type == 0) {
            throw new RuntimeException("cannot set a vector uniform to a matrix");
        }
        if (this.type == 1) {
            throw new RuntimeException("cannot set an integer uniform with matrix information");
        }
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        if (this.vecSize != 4) {
            throw new RuntimeException("mat" + this.vecSize + " is not yet supported");
        }
        GL20.glUniformMatrix4fv(pos, false, info.get(new float[16]));
    }

    public void set(Vector4f info) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform4f(pos, info.x, info.y, info.z, info.w);
    }

    public void set(Vector3f info) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform3f(pos, info.x, info.y, info.z);
    }

    public void set(Vector2f info) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform2f(pos, info.x, info.y);
    }

    public void set(float info) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform1f(pos, info);
    }

    public void set(float infoa, float infob) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform2f(pos, infoa, infob);
    }

    public void set(float infoa, float infob, float infoc) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform3f(pos, infoa, infob, infoc);
    }

    public void set(float infoa, float infob, float infoc, float infod) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform4f(pos, infoa, infob, infoc, infod);
    }

    public void set(int info) {
        int pos = GL20.glGetUniformLocation(ShaderProgram.currentShaderProgram.getID(), this.name);
        GL20.glUniform1i(pos, info);
    }
}

