/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.OpenGL.Attribute;
import engine.OpenGL.Sampler;
import engine.OpenGL.Uniform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.lwjgl.opengl.GL20;

public class Shader {
    public static ArrayList<Integer> shaderIDs = new ArrayList();
    private int id;
    public Attribute[] attributes;
    public Uniform[] uniforms;
    public Sampler[] samplers;

    /*
     * Could not resolve type clashes
     */
    public Shader(String path, int stype) {
        String shaderSource = "";
        try {
            int i;
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(path)));
            ArrayList<Attribute> tempattriblist = new ArrayList<Attribute>();
            ArrayList<Uniform> tempuniflist = new ArrayList<Uniform>();
            ArrayList<String> tempSamplerList = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                int startIndex;
                if (line.startsWith("layout (location")) {
                    startIndex = 15;
                    for (int c : line.substring(15).toCharArray()) {
                        ++startIndex;
                        if (c == 61) break;
                    }
                    String locStr = "";
                    char[] cArray = line.substring(startIndex).toCharArray();
                    int n = cArray.length;
                    for (int c = 0; c < n; ++c) {
                        int c2 = cArray[c];
                        ++startIndex;
                        if (c2 == 41) break;
                        if (c2 == 32) continue;
                        locStr = locStr + (char)c2;
                    }
                    int loc = Integer.parseInt(locStr);
                    String type = "";
                    for (char c : line.substring(++startIndex).toCharArray()) {
                        ++startIndex;
                        if (c == ' ') break;
                    }
                    for (char c : line.substring(startIndex).toCharArray()) {
                        ++startIndex;
                        if (c != ' ') {
                            type = type + c;
                            continue;
                        }
                        if (type.length() > 0) break;
                    }
                    String name = "";
                    for (char c : line.substring(startIndex).toCharArray()) {
                        if (c == ' ' || c == ';') continue;
                        name = name + c;
                    }
                    int vecSize = 0;
                    if (type.equals("float")) {
                        vecSize = 1;
                    } else if (type.startsWith("vec")) {
                        vecSize = Integer.parseInt(type.substring(3));
                    } else if (type.startsWith("mat")) {
                        vecSize = Integer.parseInt(type.substring(3));
                    } else {
                        throw new IOException("Invalid attribute type in shader");
                    }
                    tempattriblist.add(new Attribute(vecSize, name, loc));
                } else if (line.startsWith("uniform ")) {
                    startIndex = 8;
                    String type = "";
                    for (int c2 : line.substring(startIndex).toCharArray()) {
                        ++startIndex;
                        if (c2 == 32) break;
                        type = type + (char)c2;
                    }
                    String name = "";
                    for (char c : line.substring(startIndex).toCharArray()) {
                        if (c == ' ' || c == ';') continue;
                        name = name + c;
                    }
                    int vecSize = 0;
                    if (type.equals("float")) {
                        vecSize = 1;
                        tempuniflist.add(new Uniform(name, vecSize));
                    } else if (type.startsWith("vec")) {
                        vecSize = Integer.parseInt(type.substring(3));
                        tempuniflist.add(new Uniform(name, vecSize));
                    } else if (type.startsWith("mat")) {
                        vecSize = Integer.parseInt(type.substring(3));
                        tempuniflist.add(new Uniform(name, vecSize, 2));
                    } else if (type.startsWith("int")) {
                        vecSize = 1;
                        tempuniflist.add(new Uniform(name, vecSize, 1));
                    } else if (type.startsWith("sampler")) {
                        tempSamplerList.add(name);
                    }
                }
                shaderSource = shaderSource + line + "\n";
            }
            this.attributes = new Attribute[tempattriblist.size()];
            for (i = 0; i < tempattriblist.size(); ++i) {
                this.attributes[i] = (Attribute)tempattriblist.get(i);
            }
            this.uniforms = new Uniform[tempuniflist.size()];
            for (i = 0; i < tempuniflist.size(); ++i) {
                this.uniforms[i] = (Uniform)tempuniflist.get(i);
            }
            this.samplers = new Sampler[tempSamplerList.size()];
            for (i = 0; i < this.samplers.length; ++i) {
                this.samplers[i] = new Sampler((String)tempSamplerList.get(i));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.id = GL20.glCreateShader(stype);
        GL20.glShaderSource(this.id, (CharSequence)shaderSource);
        GL20.glCompileShader(this.id);
        if (GL20.glGetShaderi(this.id, 35713) != 1) {
            throw new RuntimeException("Failed to compile shader: " + path + "! " + GL20.glGetShaderInfoLog(this.id));
        }
    }

    public int getID() {
        return this.id;
    }

    public void destroy() {
        GL20.glDeleteShader(this.id);
        for (int i = 0; i < shaderIDs.size(); ++i) {
            if (shaderIDs.get(i) != this.id) continue;
            shaderIDs.remove(i);
        }
    }
}

