/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenGL;

import engine.Entities.Camera;
import engine.Entities.GameObject;
import engine.OpenAL.Sound;
import engine.OpenAL.SoundSource;
import engine.OpenGL.FBO;
import engine.OpenGL.ShaderProgram;
import engine.OpenGL.VAO;
import engine.OpenGL.VBO;
import game.MainView;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;

public class EnigWindow {
    public long id;
    private int width;
    private int height;
    private float aspectRatio;
    public int fps = 144;
    public float cursorXFloat;
    public float cursorYFloat;
    public double cursorXDouble;
    public double cursorYDouble;
    public double cursorXOffset;
    public double cursorYOffset;
    public boolean inputEnabled = false;
    public boolean printFrames = false;
    public boolean fullscreen = false;
    public int[] mouseButtons = new int[8];
    public int[] keys = new int[349];
    public int mousePressStatus;
    public int framesSinceLastSecond = 0;
    public int lastFrameCount = 0;
    public long lastSecond;
    private long device;
    private long context;
    private ALCCapabilities deviceCapablities;
    public static EnigWindow mainWindow;
    public static boolean runOpeningSequence;
    private long variableYieldTime;
    private long lastTime;

    public EnigWindow(String title) {
        this.maxInit(title, false, true);
    }

    public EnigWindow(String title, String iconPath) {
        this.maxInit(title, false, true);
        this.setIcon(iconPath);
    }

    public EnigWindow(String title, boolean decorated) {
        this.init(title, decorated);
    }

    public EnigWindow(String title, String iconPath, boolean decorated) {
        this.init(title, decorated);
        this.setIcon(iconPath);
    }

    public EnigWindow(int w, int h, String title) {
        this.init(w, h, title, true);
    }

    public EnigWindow(int w, int h, String title, String iconPath) {
        this.init(w, h, title, true);
        this.setIcon(iconPath);
    }

    public EnigWindow(int w, int h, String title, boolean decorated) {
        this.init(w, h, title, decorated);
    }

    public EnigWindow(int w, int h, String title, String iconPath, boolean decorated) {
        this.init(w, h, title, decorated);
        this.setIcon(iconPath);
    }

    public void terminate() {
        Callbacks.glfwFreeCallbacks(this.id);
        GLFW.glfwDestroyWindow(this.id);
        GLFW.glfwTerminate();
        GLFW.glfwSetErrorCallback(null).free();
        ALC10.alcDestroyContext(this.context);
        ALC10.alcCloseDevice(this.device);
        for (Integer i : VAO.vaoIDs) {
            GL30.glDeleteVertexArrays(i);
        }
        for (Integer i : VBO.vboIDs) {
            GL15.glDeleteBuffers(i);
        }
        for (Integer i : VAO.vaoIDs) {
            GL30.glDeleteTextures(i);
        }
        for (Integer i : FBO.fboIDs) {
            GL30.glDeleteFramebuffers(i);
        }
        for (Integer i : FBO.renderBufferIDs) {
            GL30.glDeleteRenderbuffers(i);
        }
        for (Integer i : Sound.soundIDs) {
            AL10.alDeleteBuffers(i);
        }
        for (Integer i : SoundSource.sourceIDs) {
            AL10.alDeleteSources(i);
        }
    }

    public void init(String title, boolean decorated) {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(135181, 4);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 0);
        GLFW.glfwWindowHint(131077, decorated ? 1 : 0);
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 3);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(139270, 1);
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        this.width = vidMode.width();
        this.height = vidMode.height();
        this.setAspectRatio();
        this.id = GLFW.glfwCreateWindow(this.width, this.height, title, GLFW.glfwGetPrimaryMonitor(), 0L);
        if (this.id == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        GLFW.glfwSetKeyCallback(this.id, (window, key, scancode, action, mods) -> {
            if (key >= 0) {
                this.keys[key] = action;
            }
        });
        GLFW.glfwSetCursorPosCallback(this.id, new GLFWCursorPosCallback(){

            @Override
            public void invoke(long window, double xpos, double ypos) {
                if (EnigWindow.this.inputEnabled) {
                    EnigWindow.this.cursorXOffset += EnigWindow.this.cursorXDouble - xpos;
                    EnigWindow.this.cursorYOffset += EnigWindow.this.cursorYDouble - ypos;
                    EnigWindow.this.cursorXDouble = xpos;
                    EnigWindow.this.cursorYDouble = ypos;
                    EnigWindow.this.cursorXFloat = (float)(2.0 * xpos - (double)EnigWindow.this.width) / (float)EnigWindow.this.width;
                    EnigWindow.this.cursorYFloat = (float)(2.0 * ypos - (double)EnigWindow.this.height) / (float)EnigWindow.this.height;
                } else {
                    EnigWindow.this.cursorXDouble = xpos;
                    EnigWindow.this.cursorYDouble = ypos;
                    EnigWindow.this.cursorXFloat = (float)(2.0 * xpos - (double)EnigWindow.this.width) / (float)EnigWindow.this.width;
                    EnigWindow.this.cursorYFloat = (float)(-(2.0 * ypos - (double)EnigWindow.this.height)) / (float)EnigWindow.this.height;
                }
            }
        });
        GLFW.glfwSetMouseButtonCallback(this.id, (window, button, action, mods) -> {
            if (action >= 0) {
                this.mouseButtons[button] = action;
            }
        });
        GLFW.glfwSetScrollCallback(this.id, (window, xOffset, yOffset) -> {
            if (MainView.main.player.weapons.size() > 0) {
                MainView.main.player.selectedWeaponIndex = yOffset > 0.0 ? --MainView.main.player.selectedWeaponIndex : ++MainView.main.player.selectedWeaponIndex;
                if (MainView.main.player.selectedWeaponIndex < 0) {
                    MainView.main.player.selectedWeaponIndex += MainView.main.player.weapons.size();
                } else if (MainView.main.player.selectedWeaponIndex >= MainView.main.player.weapons.size()) {
                    MainView.main.player.selectedWeaponIndex -= MainView.main.player.weapons.size();
                }
                MainView.main.player.weapons.get((int)MainView.main.player.selectedWeaponIndex).attackFrame = -10;
                if (MainView.main.tutorialFrame == 3) {
                    MainView.main.tutorialFrame = -1;
                }
            }
        });
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.id, pWidth, pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.id, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.id);
        GLFW.glfwSwapInterval(1);
        GLFW.glfwSetInputMode(this.id, 208897, 212993);
        GLFW.glfwShowWindow(this.id);
        GLFW.glfwSetWindowSizeCallback(this.id, (window, w, h) -> {
            this.width = w;
            this.height = h;
            this.setAspectRatio();
            this.setViewport();
        });
        this.initOpenGL();
        GL30.glEnable(3042);
        GL30.glEnable(2929);
        GL30.glEnable(2884);
        GL30.glBlendFunc(770, 771);
        GL30.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.initOpenAL();
        mainWindow = this;
        if (runOpeningSequence) {
            this.runOpeningSequence();
        }
    }

    public void init(int iw, int ih, String title, boolean decorated) {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(135181, 4);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 1);
        GLFW.glfwWindowHint(131077, decorated ? 1 : 0);
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 3);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(139270, 1);
        this.width = iw;
        this.height = ih;
        this.setAspectRatio();
        this.id = GLFW.glfwCreateWindow(this.width, this.height, title, 0L, 0L);
        if (this.id == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        GLFW.glfwSetKeyCallback(this.id, (window, key, scancode, action, mods) -> {
            if (key >= 0) {
                this.keys[key] = action;
            }
        });
        GLFW.glfwSetCursorPosCallback(this.id, new GLFWCursorPosCallback(){

            @Override
            public void invoke(long window, double xpos, double ypos) {
                if (EnigWindow.this.inputEnabled) {
                    EnigWindow.this.cursorXOffset += EnigWindow.this.cursorXDouble - xpos;
                    EnigWindow.this.cursorYOffset += EnigWindow.this.cursorYDouble - ypos;
                    EnigWindow.this.cursorXDouble = xpos;
                    EnigWindow.this.cursorYDouble = ypos;
                    EnigWindow.this.cursorXFloat = (float)(2.0 * xpos - (double)EnigWindow.this.width) / (float)EnigWindow.this.width;
                    EnigWindow.this.cursorYFloat = (float)(2.0 * ypos - (double)EnigWindow.this.height) / (float)EnigWindow.this.height;
                } else {
                    EnigWindow.this.cursorXDouble = xpos;
                    EnigWindow.this.cursorYDouble = ypos;
                    EnigWindow.this.cursorXFloat = (float)(2.0 * xpos - (double)EnigWindow.this.width) / (float)EnigWindow.this.width;
                    EnigWindow.this.cursorYFloat = (float)(-(2.0 * ypos - (double)EnigWindow.this.height)) / (float)EnigWindow.this.height;
                }
            }
        });
        GLFW.glfwSetMouseButtonCallback(this.id, (window, button, action, mods) -> {
            if (action >= 0) {
                this.mouseButtons[button] = action;
            }
        });
        GLFW.glfwSetScrollCallback(this.id, (window, xOffset, yOffset) -> {
            if (MainView.main.player.weapons.size() > 0) {
                MainView.main.player.selectedWeaponIndex = yOffset > 0.0 ? --MainView.main.player.selectedWeaponIndex : ++MainView.main.player.selectedWeaponIndex;
                if (MainView.main.player.selectedWeaponIndex < 0) {
                    MainView.main.player.selectedWeaponIndex += MainView.main.player.weapons.size();
                } else if (MainView.main.player.selectedWeaponIndex >= MainView.main.player.weapons.size()) {
                    MainView.main.player.selectedWeaponIndex -= MainView.main.player.weapons.size();
                }
                MainView.main.player.weapons.get((int)MainView.main.player.selectedWeaponIndex).attackFrame = -10;
                if (MainView.main.tutorialFrame == 3) {
                    MainView.main.tutorialFrame = -1;
                }
            }
        });
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.id, pWidth, pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.id, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.id);
        GLFW.glfwSwapInterval(1);
        GLFW.glfwSetInputMode(this.id, 208897, 212993);
        GLFW.glfwShowWindow(this.id);
        GLFW.glfwSetWindowSizeCallback(this.id, (window, w, h) -> {
            this.width = w;
            this.height = h;
            this.setViewport();
        });
        this.initOpenGL();
        GL30.glEnable(3042);
        GL30.glEnable(2929);
        GL30.glEnable(2884);
        GL30.glBlendFunc(770, 771);
        GL30.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.initOpenAL();
        mainWindow = this;
        if (runOpeningSequence) {
            this.runOpeningSequence();
        }
    }

    public void maxInit(String title, boolean decorated, boolean resizeable) {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(135181, 4);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, resizeable ? 1 : 0);
        GLFW.glfwWindowHint(131077, decorated ? 1 : 0);
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 3);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(139270, 1);
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        this.width = vidMode.width();
        this.height = vidMode.height();
        this.setAspectRatio();
        this.id = GLFW.glfwCreateWindow(this.width, this.height, title, 0L, 0L);
        if (this.id == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        GLFW.glfwSetKeyCallback(this.id, (window, key, scancode, action, mods) -> {
            if (key >= 0) {
                this.keys[key] = action;
            }
        });
        GLFW.glfwSetCursorPosCallback(this.id, new GLFWCursorPosCallback(){

            @Override
            public void invoke(long window, double xpos, double ypos) {
                if (EnigWindow.this.inputEnabled) {
                    EnigWindow.this.cursorXOffset += EnigWindow.this.cursorXDouble - xpos;
                    EnigWindow.this.cursorYOffset += EnigWindow.this.cursorYDouble - ypos;
                    EnigWindow.this.cursorXDouble = xpos;
                    EnigWindow.this.cursorYDouble = ypos;
                    EnigWindow.this.cursorXFloat = (float)(2.0 * xpos - (double)EnigWindow.this.width) / (float)EnigWindow.this.width;
                    EnigWindow.this.cursorYFloat = (float)(2.0 * ypos - (double)EnigWindow.this.height) / (float)EnigWindow.this.height;
                } else {
                    EnigWindow.this.cursorXDouble = xpos;
                    EnigWindow.this.cursorYDouble = ypos;
                    EnigWindow.this.cursorXFloat = (float)(2.0 * xpos - (double)EnigWindow.this.width) / (float)EnigWindow.this.width;
                    EnigWindow.this.cursorYFloat = (float)(-(2.0 * ypos - (double)EnigWindow.this.height)) / (float)EnigWindow.this.height;
                }
            }
        });
        GLFW.glfwSetMouseButtonCallback(this.id, (window, button, action, mods) -> {
            if (action >= 0) {
                this.mouseButtons[button] = action;
            }
        });
        GLFW.glfwSetScrollCallback(this.id, (window, xOffset, yOffset) -> {
            if (MainView.main.player.weapons.size() > 0) {
                MainView.main.player.selectedWeaponIndex = yOffset > 0.0 ? --MainView.main.player.selectedWeaponIndex : ++MainView.main.player.selectedWeaponIndex;
                if (MainView.main.player.selectedWeaponIndex < 0) {
                    MainView.main.player.selectedWeaponIndex += MainView.main.player.weapons.size();
                } else if (MainView.main.player.selectedWeaponIndex >= MainView.main.player.weapons.size()) {
                    MainView.main.player.selectedWeaponIndex -= MainView.main.player.weapons.size();
                }
                MainView.main.player.weapons.get((int)MainView.main.player.selectedWeaponIndex).attackFrame = -10;
                if (MainView.main.tutorialFrame == 3) {
                    MainView.main.tutorialFrame = -1;
                }
            }
        });
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.id, pWidth, pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.id, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.id);
        GLFW.glfwSwapInterval(1);
        GLFW.glfwSetInputMode(this.id, 208897, 212993);
        GLFW.glfwShowWindow(this.id);
        GLFW.glfwSetWindowSizeCallback(this.id, (window, w, h) -> {
            this.width = w;
            this.height = h;
            this.setViewport();
        });
        this.initOpenGL();
        GL30.glEnable(3042);
        GL30.glEnable(2929);
        GL30.glEnable(2884);
        GL30.glBlendFunc(770, 771);
        GL30.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.initOpenAL();
        mainWindow = this;
        if (runOpeningSequence) {
            this.runOpeningSequence();
        }
    }

    public void runOpeningSequence() {
        System.out.println("OpenGL Version " + GL30.glGetString(7938));
        System.out.println("GLSL   Version " + GL30.glGetString(35724));
        int frame = 0;
        ShaderProgram openingShader = new ShaderProgram("res/shaders/openingShaders/vert", "res/shaders/openingShaders/frag");
        GameObject openingObject = new GameObject("res/objects/enignets.obj");
        Camera openingCamera = new Camera(0.84823f, 0.01f, 1000.0f);
        openingCamera.usingStaticRotation = true;
        openingCamera.orderOfTransformations = new int[]{0, 2, 1};
        openingCamera.translate(0.0f, 0.0f, -5.0f);
        openingCamera.pitch(1.5707964f);
        while (openingCamera.getPitch() < 4.712389f && this.keys[32] != 1) {
            if (GLFW.glfwWindowShouldClose(this.id)) {
                return;
            }
            openingCamera.setPos(0.0f, 0.0f, (float)(13.0 - 10.0 * Math.pow(150.0f - (float)frame * 2.0f, 6.0) / 1.1390625E13));
            openingCamera.pitch(0.022f);
            this.update();
            GL30.glClear(16640);
            openingShader.enable();
            openingShader.shaders[2].uniforms[0].set(new float[]{++frame});
            openingShader.shaders[2].uniforms[1].set(new float[]{this.width, this.height});
            openingObject.render(openingCamera);
            ShaderProgram.disable();
            GLFW.glfwSwapBuffers(this.id);
            GLFW.glfwPollEvents();
            this.sync(60);
        }
        openingCamera.setPos(0.0f, 0.0f, 7.4449763f);
        openingCamera.setPitch(4.712389f);
        this.update();
        GL30.glClear(16640);
        openingShader.enable();
        openingShader.shaders[2].uniforms[0].set(new float[]{frame});
        openingShader.shaders[2].uniforms[1].set(new float[]{this.width, this.height});
        openingObject.render(openingCamera);
        ShaderProgram.disable();
        GLFW.glfwSwapBuffers(this.id);
        GLFW.glfwPollEvents();
        float fov = 0.84823f;
        for (frame = 286; frame < 343; ++frame) {
            if (GLFW.glfwWindowShouldClose(this.id)) {
                return;
            }
            if (this.keys[32] == 1) {
                frame = 370;
            }
            fov = (float)((double)fov - 0.0148786180752367);
            openingCamera.setPos(0.0f, 0.0f, (float)(16.88933655389 * Math.sqrt(1.0 / (1.0 + Math.tan(fov) * Math.tan(fov))) / (2.0 * Math.sin(fov))));
            openingCamera.setPerspective(fov, 0.01f, 1.0E38f);
            this.update();
            GL30.glClear(16640);
            openingShader.enable();
            openingShader.shaders[2].uniforms[0].set(new float[]{frame});
            openingShader.shaders[2].uniforms[1].set(new float[]{this.width, this.height});
            openingObject.render(openingCamera);
            ShaderProgram.disable();
            this.resetOffsets();
            GLFW.glfwSwapBuffers(this.id);
            GLFW.glfwPollEvents();
            EnigWindow.checkGLError();
            this.sync(60);
        }
        fov = 1.0E-4f;
        openingCamera.setPos(0.0f, 0.0f, (float)(16.88933655389 * Math.sqrt(1.0 / (1.0 + Math.tan(fov) * Math.tan(fov))) / (2.0 * Math.sin(fov))));
        openingCamera.setPerspective(fov, 0.01f, 1.0E38f);
        this.update();
        GL30.glClear(16640);
        openingShader.enable();
        openingShader.shaders[2].uniforms[0].set(new float[]{frame});
        openingShader.shaders[2].uniforms[1].set(new float[]{this.width, this.height});
        openingObject.render(openingCamera);
        ShaderProgram.disable();
        this.resetOffsets();
        GLFW.glfwSwapBuffers(this.id);
        GLFW.glfwPollEvents();
        while (frame < 370) {
            ++frame;
            if (GLFW.glfwWindowShouldClose(this.id)) {
                return;
            }
            if (this.keys[32] > 0) {
                return;
            }
            this.resetOffsets();
            GLFW.glfwPollEvents();
            this.sync(60);
        }
        GL30.glDisable(2884);
    }

    public static void checkGLError() {
        int error = GL30.glGetError();
        if (error != 0) {
            String errorInfo = "idk";
            switch (error) {
                case 1280: {
                    errorInfo = "Invalid enum";
                }
                case 1281: {
                    errorInfo = "Invalid value";
                }
                case 1282: {
                    errorInfo = "Invalid operation";
                }
                case 1283: {
                    errorInfo = "Stack overflow";
                }
                case 1284: {
                    errorInfo = "Stack underflow";
                }
                case 1285: {
                    errorInfo = "Out of memory";
                }
                case 32817: {
                    errorInfo = "Table too large";
                }
                case 1286: {
                    errorInfo = "Invalid framebuffer operation";
                }
            }
            errorInfo = "I rly dik";
            System.out.println("id: " + error + " : " + errorInfo);
            throw new RuntimeException("id: " + error + " : " + errorInfo);
        }
    }

    private void setAspectRatio() {
        this.aspectRatio = (float)this.width / (float)this.height;
    }

    public void initOpenGL() {
        GL.createCapabilities();
    }

    public void initOpenAL() {
        this.device = ALC10.alcOpenDevice((ByteBuffer)null);
        if (this.device == 0L) {
            throw new IllegalStateException("Failed to open the default device.");
        }
        this.deviceCapablities = ALC.createCapabilities(this.device);
        this.context = ALC10.alcCreateContext(this.device, (IntBuffer)null);
        if (this.context == 0L) {
            throw new IllegalStateException("Failed to create an OpenAL context.");
        }
        ALC10.alcMakeContextCurrent(this.context);
        AL.createCapabilities(this.deviceCapablities);
    }

    public void update() {
        int i;
        this.sync(this.fps);
        for (i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != 1) continue;
            int n = i;
            this.keys[n] = this.keys[n] + 1;
        }
        for (i = 0; i < this.mouseButtons.length; ++i) {
            if (this.mouseButtons[i] != 1) continue;
            int n = i;
            this.mouseButtons[n] = this.mouseButtons[n] + 1;
        }
    }

    public void resetOffsets() {
        this.cursorXOffset = 0.0;
        this.cursorYOffset = 0.0;
        ++this.framesSinceLastSecond;
        long time = System.nanoTime();
        if (time - this.lastSecond >= 1000000000L) {
            this.lastSecond = time;
            this.lastFrameCount = this.framesSinceLastSecond;
            this.framesSinceLastSecond = 0;
            if (this.printFrames) {
                System.out.println("FPS: " + this.lastFrameCount);
            }
        }
    }

    public boolean toggleCursorInput() {
        if (this.inputEnabled) {
            GLFW.glfwSetInputMode(this.id, 208897, 212993);
        } else {
            GLFW.glfwSetInputMode(this.id, 208897, 212995);
        }
        this.inputEnabled = !this.inputEnabled;
        return this.inputEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(int fps) {
        if (fps <= 0) {
            return;
        }
        long sleepTime = 1000000000 / fps;
        long yieldTime = Math.min(sleepTime, this.variableYieldTime + sleepTime % 1000000L);
        long overSleep = 0L;
        try {
            long t;
            while (true) {
                if ((t = System.nanoTime() - this.lastTime) < sleepTime - yieldTime) {
                    continue;
                }
                if (t >= sleepTime) break;
                Thread.yield();
            }
            overSleep = t - sleepTime;
        }
        finally {
            this.lastTime = System.nanoTime() - Math.min(overSleep, sleepTime);
            if (overSleep > this.variableYieldTime) {
                this.variableYieldTime = Math.min(this.variableYieldTime + 200000L, sleepTime);
            } else if (overSleep < this.variableYieldTime - 200000L) {
                this.variableYieldTime = Math.max(this.variableYieldTime - 2000L, 0L);
            }
        }
    }

    public void setViewport() {
        int[] fbwidth = new int[1];
        int[] fbheight = new int[1];
        GLFW.glfwGetFramebufferSize(this.id, fbwidth, fbheight);
        GL30.glViewport(0, 0, fbwidth[0], fbheight[0]);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public Matrix4f getSquarePerspectiveMatrix(float maxHeight) {
        return new Matrix4f().ortho(-maxHeight / 2.0f * this.getAspectRatio(), maxHeight / 2.0f * this.getAspectRatio(), -maxHeight / 2.0f, maxHeight / 2.0f, 0.0f, 1.0f);
    }

    public void setIcon(String imagePath) {
        GLFWImage image = EnigWindow.makeGLFWImage(imagePath);
        GLFWImage.Buffer buffer = GLFWImage.malloc(1);
        buffer.put(0, image);
        GLFW.glfwSetWindowIcon(this.id, buffer);
    }

    public static GLFWImage makeGLFWImage(String imagePath) {
        BufferedImage b = null;
        try {
            b = ImageIO.read(EnigWindow.class.getClassLoader().getResource(imagePath));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        int bwi = b.getWidth();
        int bhi = b.getHeight();
        int len = bwi * bhi;
        int[] rgbArray = new int[len];
        System.out.println();
        b.getRGB(0, 0, bwi, bhi, rgbArray, 0, bwi);
        ByteBuffer buffer = BufferUtils.createByteBuffer(len * 4);
        for (int i = 0; i < len; ++i) {
            int rgb = rgbArray[i];
            buffer.put((byte)(rgb >> 16 & 0xFF));
            buffer.put((byte)(rgb >> 8 & 0xFF));
            buffer.put((byte)(rgb & 0xFF));
            buffer.put((byte)(rgb >> 24 & 0xFF));
        }
        buffer.flip();
        GLFWImage img = GLFWImage.create();
        img.width(bwi);
        img.height(bhi);
        img.pixels(buffer);
        return img;
    }

    static {
        runOpeningSequence = true;
    }
}

