/*
 * Decompiled with CFR 0.152.
 */
package engine.OpenAL;

import com.sun.media.sound.WaveFileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.lwjgl.openal.AL10;

public class Sound {
    public static ArrayList<Integer> soundIDs = new ArrayList();
    private int id;

    public Sound(String file) {
        try {
            this.id = AL10.alGenBuffers();
            soundIDs.add(this.id);
            InputStream url = this.getClass().getClassLoader().getResourceAsStream(file);
            AudioInputStream ais = new WaveFileReader().getAudioInputStream(url);
            AudioFormat format = ais.getFormat();
            int channels = 0;
            if (format.getChannels() == 1) {
                if (format.getSampleSizeInBits() == 8) {
                    channels = 4352;
                } else if (format.getSampleSizeInBits() == 16) {
                    channels = 4353;
                } else assert (false) : "Illegal sample size";
            } else if (format.getChannels() == 2) {
                if (format.getSampleSizeInBits() == 8) {
                    channels = 4354;
                } else if (format.getSampleSizeInBits() == 16) {
                    channels = 4355;
                } else assert (false) : "Illegal sample size";
            } else assert (false) : "Only mono or stereo is supported";
            ByteBuffer buffer = null;
            int available = ais.available();
            if (available <= 0) {
                available = ais.getFormat().getChannels() * (int)ais.getFrameLength() * ais.getFormat().getSampleSizeInBits() / 8;
            }
            byte[] buf = new byte[ais.available()];
            int read = 0;
            for (int total = 0; (read = ais.read(buf, total, buf.length - total)) != -1 && total < buf.length; total += read) {
            }
            ByteBuffer dest = ByteBuffer.allocateDirect(buf.length);
            dest.order(ByteOrder.nativeOrder());
            ByteBuffer src = ByteBuffer.wrap(buf);
            src.order(format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            if (format.getSampleSizeInBits() == 16) {
                ShortBuffer dest_short = dest.asShortBuffer();
                ShortBuffer src_short = src.asShortBuffer();
                while (src_short.hasRemaining()) {
                    dest_short.put(src_short.get());
                }
            } else {
                while (src.hasRemaining()) {
                    dest.put(src.get());
                }
            }
            dest.rewind();
            buffer = dest;
            AL10.alBufferData(this.id, channels, buffer, (int)format.getSampleRate());
            buffer.clear();
            try {
                ais.close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getID() {
        return this.id;
    }
}

