/*
 * Decompiled with CFR 0.152.
 */
package engine.Entities;

import engine.EnigUtils;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PositionInfo
extends Vector3f {
    private Matrix4f rotationMatrix;
    private Vector3f rotations;
    private float scale = 1.0f;
    private boolean needsUpdate = true;

    public PositionInfo() {
        this.rotationMatrix = new Matrix4f();
    }

    public PositionInfo(float x, float y, float z) {
        super(x, y, z);
        this.rotationMatrix = new Matrix4f();
    }

    public PositionInfo(float x, float y, float z, float pitch, float yaw, float roll) {
        super(x, y, z);
        this.rotationMatrix = new Matrix4f().setRotationXYZ(pitch, yaw, roll);
    }

    public PositionInfo(float x, float y, float z, Matrix4f rotationMatrix) {
        super(x, y, z);
        this.rotationMatrix = rotationMatrix;
    }

    public Vector3f getRotations() {
        if (this.needsUpdate) {
            this.rotations = EnigUtils.getEulerAngles(this.rotationMatrix);
            this.needsUpdate = false;
        }
        return this.rotations;
    }

    public void setRotations(float ax, float ay, float az) {
        this.rotationMatrix = new Matrix4f().setRotationXYZ(ax, ay, az);
        this.needsUpdate = true;
    }

    public float getPitch() {
        if (this.needsUpdate) {
            this.rotations = EnigUtils.getEulerAngles(this.rotationMatrix);
            this.needsUpdate = false;
        }
        return this.rotations.x;
    }

    public float getYaw() {
        if (this.needsUpdate) {
            this.rotations = EnigUtils.getEulerAngles(this.rotationMatrix);
            this.needsUpdate = false;
        }
        return this.rotations.y;
    }

    public float getRoll() {
        if (this.needsUpdate) {
            this.rotations = EnigUtils.getEulerAngles(this.rotationMatrix);
            this.needsUpdate = false;
        }
        return this.rotations.z;
    }

    public void setPos(Vector3f npos) {
        this.x = npos.x;
        this.y = npos.y;
        this.z = npos.z;
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void translate(Vector3f tpos) {
        super.add(tpos);
    }

    public void translate(float x, float y, float z) {
        super.add(x, y, z);
    }

    public void pitch(float amount) {
        Matrix4f tempRotationMatrix = new Matrix4f().rotateX(amount);
        tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        this.needsUpdate = true;
    }

    public void yaw(float amount) {
        Matrix4f tempRotationMatrix = new Matrix4f().rotateY(amount);
        tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        this.needsUpdate = true;
    }

    public void roll(float amount) {
        Matrix4f tempRotationMatrix = new Matrix4f().rotateZ(amount);
        tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        this.needsUpdate = true;
    }

    public Vector3f rotateVector(Vector3f vector) {
        return this.rotateVector(vector.x, vector.y, vector.z);
    }

    public Vector3f rotateVector(float vx, float vy, float vz) {
        Vector3f ret = new Vector3f(vx, vy, vz);
        if (this.needsUpdate) {
            this.rotations = EnigUtils.getEulerAngles(this.rotationMatrix);
            this.needsUpdate = false;
        }
        ret.rotateX(this.rotations.x);
        ret.rotateY(this.rotations.y);
        ret.rotateZ(this.rotations.z);
        return ret;
    }

    public Matrix4f getRotationMatrix() {
        return this.rotationMatrix;
    }

    public Vector3f getDirectionVector() {
        return this.rotateVector(0.0f, 0.0f, -1.0f);
    }

    public void rotateAlongAxis(float angle, Vector3f axis) {
        this.rotationMatrix.rotate(angle, axis);
        this.needsUpdate = true;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void scaleBy(float factor) {
        this.scale *= factor;
    }

    public float getScale() {
        return this.scale;
    }

    public Matrix4f translateMatrix(Matrix4f mat) {
        if (this.needsUpdate) {
            this.rotations = EnigUtils.getEulerAngles(this.rotationMatrix);
            this.needsUpdate = false;
        }
        Matrix4f ret = mat.translate(this, new Matrix4f());
        ret.rotateX(-this.rotations.x);
        ret.rotateY(-this.rotations.y);
        ret.rotateZ(-this.rotations.z);
        return ret;
    }

    public void setDirectionVector(Vector3f newVector) {
    }

    public void setLookAt(Vector3f pos) {
        this.needsUpdate = true;
        this.setDirectionVector(new Vector3f(pos.x - this.x, pos.y - this.y, pos.z - this.z));
    }
}

