/*
 * Decompiled with CFR 0.152.
 */
package engine.Entities;

import engine.EnigUtils;
import engine.OpenGL.EnigWindow;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Camera
extends Vector3f {
    public Matrix4f projectionMatrix;
    public Matrix4f rotationMatrix;
    public Vector3f calculatedRotations = new Vector3f();
    private Vector4f directionVector = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
    public boolean usingStaticRotation = true;
    private float pitch;
    private float yaw;
    private float roll;
    public int[] orderOfTransformations = new int[]{0, 1, 2};

    public Camera(Camera other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.projectionMatrix = new Matrix4f(other.projectionMatrix);
        this.rotationMatrix = new Matrix4f(other.rotationMatrix);
        this.calculatedRotations = new Vector3f(other.calculatedRotations);
        this.directionVector = new Vector4f(other.directionVector);
        this.usingStaticRotation = other.usingStaticRotation;
        this.pitch = other.pitch;
        this.yaw = other.yaw;
        this.roll = other.roll;
        this.orderOfTransformations = other.orderOfTransformations;
    }

    public Camera(float fieldOfView, float minDistance, float renderDistance) {
        float aspectRatio = (float)EnigWindow.mainWindow.getWidth() / (float)EnigWindow.mainWindow.getHeight();
        this.projectionMatrix = new Matrix4f().perspective(fieldOfView, aspectRatio, minDistance, renderDistance);
        this.rotationMatrix = new Matrix4f();
        this.setPos(0.0f, 0.0f, 0.0f);
    }

    public Camera(float fieldOfView, float minDistance, float renderDistance, EnigWindow window) {
        float aspectRatio = (float)window.getWidth() / (float)window.getHeight();
        this.projectionMatrix = new Matrix4f().perspective(fieldOfView, aspectRatio, minDistance, renderDistance);
        this.rotationMatrix = new Matrix4f();
        this.setPos(0.0f, 0.0f, 0.0f);
    }

    public Camera(float fieldOfView, float minDistance, float renderDistance, int first, int second, int third) {
        float aspectRatio = (float)EnigWindow.mainWindow.getWidth() / (float)EnigWindow.mainWindow.getHeight();
        this.projectionMatrix = new Matrix4f().perspective(fieldOfView, aspectRatio, minDistance, renderDistance);
        this.rotationMatrix = new Matrix4f();
        this.orderOfTransformations = new int[]{first, second, third};
        this.setPos(0.0f, 0.0f, 0.0f);
    }

    public Camera(float fieldOfView, float minDistance, float renderDistance, EnigWindow window, int first, int second, int third) {
        float aspectRatio = (float)window.getWidth() / (float)window.getHeight();
        this.projectionMatrix = new Matrix4f().perspective(fieldOfView, aspectRatio, minDistance, renderDistance);
        this.rotationMatrix = new Matrix4f();
        this.orderOfTransformations = new int[]{first, second, third};
        this.setPos(0.0f, 0.0f, 0.0f);
    }

    public Camera(float minDistance, float farDistance) {
        this.projectionMatrix = new Matrix4f().ortho(-100.0f, 100.0f, -100.0f, 100.0f, minDistance, farDistance);
        this.rotationMatrix = new Matrix4f();
        this.setPos(0.0f, 0.0f, 0.0f);
    }

    public Vector3f getPos() {
        return new Vector3f(this);
    }

    public void setPerspective(float fov, float minDistance, float renderDistance) {
        float aspectRatio = (float)EnigWindow.mainWindow.getWidth() / (float)EnigWindow.mainWindow.getHeight();
        this.projectionMatrix = new Matrix4f().perspective(fov, aspectRatio, minDistance, renderDistance);
    }

    public void setPos(Vector3f npos) {
        this.x = npos.x;
        this.y = npos.y;
        this.z = npos.z;
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void translate(Vector3f tpos) {
        super.add(tpos);
    }

    public void translate(float x, float y, float z) {
        super.add(x, y, z);
    }

    public void pitch(float v) {
        if (this.usingStaticRotation) {
            this.pitch += v;
            this.rotationMatrix.setRotationXYZ(this.pitch, this.yaw, this.roll);
        } else {
            Matrix4f tempRotationMatrix = new Matrix4f().rotateX(v);
            this.directionVector.rotateX(v);
            tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        }
    }

    public void yaw(float v) {
        if (this.usingStaticRotation) {
            this.yaw += v;
            this.rotationMatrix.setRotationXYZ(this.pitch, this.yaw, this.roll);
        } else {
            Matrix4f tempRotationMatrix = new Matrix4f().rotateY(v);
            this.directionVector.rotateY(v);
            tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        }
    }

    public void roll(float v) {
        if (this.usingStaticRotation) {
            this.roll += v;
            this.rotationMatrix.setRotationXYZ(this.pitch, this.yaw, this.roll);
        } else {
            Matrix4f tempRotationMatrix = new Matrix4f().rotateZ(v);
            this.directionVector.rotateZ(v);
            tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        }
    }

    public Vector4f getDirectionVector() {
        return this.directionVector;
    }

    public Matrix4f getCameraMatrix() {
        Matrix4f retVal = new Matrix4f();
        for (int m : this.orderOfTransformations) {
            if (m == 0) {
                retVal = retVal.mul(this.projectionMatrix);
                continue;
            }
            if (m == 1) {
                retVal = retVal.mul(this.rotationMatrix);
                continue;
            }
            if (m != 2) continue;
            retVal = retVal.translate(-this.x, -this.y, -this.z);
        }
        return retVal;
    }

    public Matrix4f getCameraMatrix(int[] transformations) {
        Matrix4f retVal = new Matrix4f();
        for (int m : transformations) {
            if (m == 0) {
                retVal = retVal.mul(this.projectionMatrix);
                continue;
            }
            if (m == 1) {
                retVal = retVal.mul(this.rotationMatrix);
                continue;
            }
            if (m != 2) continue;
            retVal = retVal.translate(-this.x, -this.y, -this.z);
        }
        return retVal;
    }

    public Vector3f angles() {
        float z;
        float y;
        float x;
        boolean singular;
        float sy = (float)Math.sqrt(this.rotationMatrix.m00() * this.rotationMatrix.m00() + this.rotationMatrix.m10() * this.rotationMatrix.m10());
        boolean bl = singular = (double)sy < 1.0E-6;
        if (!singular) {
            x = (float)Math.atan2(this.rotationMatrix.m21(), this.rotationMatrix.m22());
            y = (float)Math.atan2(-this.rotationMatrix.m20(), sy);
            z = (float)Math.atan2(this.rotationMatrix.m10(), this.rotationMatrix.m00());
        } else {
            x = (float)Math.atan2(-this.rotationMatrix.m12(), this.rotationMatrix.m11());
            y = (float)Math.atan2(-this.rotationMatrix.m20(), sy);
            z = 0.0f;
        }
        return new Vector3f(x, y, z);
    }

    public float getPitch() {
        if (this.usingStaticRotation) {
            return this.pitch;
        }
        return this.calculatedRotations.x;
    }

    public float getYaw() {
        if (this.usingStaticRotation) {
            return this.yaw;
        }
        return this.calculatedRotations.y;
    }

    public float getRoll() {
        if (this.usingStaticRotation) {
            return this.roll;
        }
        return this.calculatedRotations.z;
    }

    public void setPitch(float v) {
        if (this.usingStaticRotation) {
            this.pitch = v;
            this.rotationMatrix.setRotationXYZ(this.pitch, this.yaw, this.roll);
        } else {
            Matrix4f tempRotationMatrix = new Matrix4f().rotateX(v);
            this.directionVector.rotateX(v);
            tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        }
    }

    public void setYaw(float v) {
        if (this.usingStaticRotation) {
            this.yaw = v;
            this.rotationMatrix.setRotationXYZ(this.pitch, this.yaw, this.roll);
        } else {
            Matrix4f tempRotationMatrix = new Matrix4f().rotateY(v);
            this.directionVector.rotateY(v);
            tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        }
    }

    public void setRoll(float v) {
        if (this.usingStaticRotation) {
            this.roll = v;
            this.rotationMatrix.setRotationXYZ(this.pitch, this.yaw, this.roll);
        } else {
            Matrix4f tempRotationMatrix = new Matrix4f().rotateZ(v);
            this.directionVector.rotateZ(v);
            tempRotationMatrix.mul(this.rotationMatrix, this.rotationMatrix);
        }
    }

    public void updateRotations() {
        this.calculatedRotations = EnigUtils.getEulerAngles(this.rotationMatrix);
    }

    public Vector3f getRotatedVector(float x, float y, float z, float s) {
        return new Vector3f(x, y, z).rotateX(-2.0f * this.pitch).rotateY(-2.0f * this.yaw).rotateZ(-2.0f * this.roll).mul(s);
    }

    public Vector2f getRotated2DVector(float x, float z, float s) {
        Vector3f ret = new Vector3f(x, 0.0f, z).rotateY(-this.yaw);
        return EnigUtils.resizeVector(ret.x, ret.z, s);
    }
}

