/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.OpenGL.EnigWindow;
import engine.OpenGL.ShaderProgram;
import org.lwjgl.glfw.GLFW;

public abstract class EnigView {
    public EnigWindow window;
    public float loopStartTime;
    public float deltaTime;
    public float frameStartTime;

    public EnigView(EnigWindow swindow) {
        this.window = swindow;
    }

    public void runLoop() {
        this.frameStartTime = this.loopStartTime = (float)System.nanoTime() / 1.0E9f;
        while (!GLFW.glfwWindowShouldClose(this.window.id)) {
            float newTime = (float)System.nanoTime() / 1.0E9f;
            this.deltaTime = this.frameStartTime - newTime;
            this.frameStartTime = newTime;
            if (this.loop()) {
                this.cleanUp();
                break;
            }
            this.window.update();
            this.cleanUp();
        }
        this.setDown();
    }

    public void cleanUp() {
        ShaderProgram.disable();
        this.window.resetOffsets();
        GLFW.glfwSwapBuffers(this.window.id);
        GLFW.glfwPollEvents();
        EnigWindow.checkGLError();
    }

    public abstract boolean loop();

    public void setDown() {
    }
}

