/*
 * Decompiled with CFR 0.152.
 */
package engine;

import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class EnigUtils {
    public static void printMatrix(Matrix4f m) {
        String retval = "[";
        retval = retval + m.m00() + ", ";
        retval = retval + m.m01() + ", ";
        retval = retval + m.m02() + ", ";
        retval = retval + m.m03() + "]\n[";
        retval = retval + m.m10() + ", ";
        retval = retval + m.m11() + ", ";
        retval = retval + m.m12() + ", ";
        retval = retval + m.m13() + "]\n[";
        retval = retval + m.m20() + ", ";
        retval = retval + m.m21() + ", ";
        retval = retval + m.m22() + ", ";
        retval = retval + m.m23() + "]\n[";
        retval = retval + m.m30() + ", ";
        retval = retval + m.m31() + ", ";
        retval = retval + m.m32() + ", ";
        retval = retval + m.m33() + "]\n";
        System.out.println(retval);
    }

    public static Vector3f getEulerAngles(Matrix4f mat) {
        float ysin = mat.m20();
        if (ysin < -0.99999f) {
            ysin = -0.99999f;
        } else if (ysin > 0.99999f) {
            ysin = 0.99999f;
        }
        float y = (float)Math.asin(ysin);
        float ycos = (float)Math.cos(y);
        float xcos = mat.m22() / ycos;
        float xsin = -mat.m21() / ycos;
        float zcos = mat.m00() / ycos;
        float zsin = -mat.m10() / ycos;
        if (xcos < -0.99999f) {
            xcos = -0.99999f;
        } else if (xcos > 0.99999f) {
            xcos = 0.99999f;
        }
        if (zcos < -0.99999f) {
            zcos = -0.99999f;
        } else if (zcos > 0.99999f) {
            zcos = 0.99999f;
        }
        float x = (float)Math.acos(xcos);
        float z = (float)Math.acos(zcos);
        if (xsin < 0.0f) {
            x = (float)Math.PI * 2 - x;
        }
        if (zsin < 0.0f) {
            z = (float)Math.PI * 2 - z;
        }
        return new Vector3f(EnigUtils.getAngle(x), EnigUtils.getAngle(y), EnigUtils.getAngle(z));
    }

    public static float getAngle(float a) {
        float ret = a;
        while (ret < 0.0f) {
            ret = (float)((double)ret + Math.PI * 2);
        }
        while ((double)ret > Math.PI * 2) {
            ret = (float)((double)ret - Math.PI * 2);
        }
        return ret;
    }

    public static void printFloatArray(float[] in) {
        System.out.print("[");
        for (float f : in) {
            System.out.print(f + ", ");
        }
        System.out.println("]");
    }

    public static void printIntArray(int[] in) {
        System.out.print("[");
        for (int f : in) {
            System.out.print(f + ", ");
        }
        System.out.println("]");
    }

    public static Vector3f resizeVector(Vector3f vec, float target) {
        return vec.mul(target / vec.length());
    }

    public static Vector2f resizeVector(Vector2f vec, float target) {
        return vec.mul(target / vec.length());
    }

    public static Vector2f resizeVector(float x, float y, float target) {
        float length = (float)Math.sqrt(x * x + y * y);
        return new Vector2f(x * target / length, y * target / length);
    }

    public static int containsPoint(int[] arrx, int[] arry, int tx, int ty) {
        for (int i = 0; i < arrx.length; ++i) {
            if (arrx[i] != tx || arry[i] != ty) continue;
            return i;
        }
        return -1;
    }

    public static int[] addArrays(int[] a, int[] b) {
        int i;
        int[] ret = new int[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            ret[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            ret[i + a.length] = b[i];
        }
        return ret;
    }

    public static float round(float in, int decPlaces) {
        float factor = (float)Math.pow(10.0, decPlaces);
        return (float)Math.round(in * factor) / factor;
    }

    public static double round(double in, int decPlaces) {
        double factor = Math.pow(10.0, decPlaces);
        return (double)Math.round(in * factor) / factor;
    }

    public static String format(float in, int room) {
        String ret;
        String string = ret = in < 0.0f ? "" + EnigUtils.round((double)in, room - 1) : "" + EnigUtils.round((double)in, room);
        while (ret.length() < room + 1) {
            if (ret.contains(".")) {
                ret = ret + "0";
                continue;
            }
            ret = ret + ".";
        }
        while (ret.length() > room + 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        if (ret.endsWith(".")) {
            ret = ret.substring(0, ret.length() - 1) + " ";
        }
        return ret;
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float compareAngles(float angleA, float angleB) {
        float a = EnigUtils.getAngle(angleA);
        float b = EnigUtils.getAngle(angleB);
        float ret = Math.abs(a - b);
        ret = (double)a < Math.PI ? Math.min(ret, Math.abs(a - b + (float)Math.PI * 2)) : Math.min(ret, Math.abs(a - b - (float)Math.PI * 2));
        return ret;
    }
}

